/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Spells.Radiance;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.events.SpellSummonEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerRecasts;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonedEntitiesCastData;
import java.util.List;
import java.util.Optional;
import net.hazen.hazennstuff.Entity.Mobs.Summons.SummonTerraprisma.SummonedTerraprisma;
import net.hazen.hazennstuff.Registries.HnSSchoolRegistry;
import net.hazen.hazennstuff.Registries.HnSSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class CallForthTerraprismaSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"hazennstuff", (String)"call_forth_terraprisma");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(HnSSchoolRegistry.RADIANCE_RESOURCE).setMaxLevel(5).setCooldownSeconds(150.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.summon_count", (Object[])new Object[]{3}), Component.translatable((String)"ui.irons_spellbooks.percent_damage", (Object[])new Object[]{(int)(100.0 + this.getDamageBonus(spellLevel, caster) * 100.0)}), Component.translatable((String)"ui.irons_spellbooks.percent_health", (Object[])new Object[]{(int)(100.0 + this.getHealthBonus(spellLevel, caster) * 100.0)}));
    }

    public CallForthTerraprismaSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 2;
        this.castTime = 20;
        this.baseManaCost = 80;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)HnSSounds.TERRAPRISMA_SUMMON.get());
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)HnSSounds.TERRAPRISMA_CASTING.get());
    }

    public double getHealthBonus(int spellLevel, LivingEntity caster) {
        return (double)(this.getSpellPower(spellLevel, (Entity)caster) - 1.0f) * 0.1;
    }

    public double getDamageBonus(int spellLevel, LivingEntity caster) {
        return (double)(this.getSpellPower(spellLevel, (Entity)caster) - 1.0f) * 0.05;
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 2;
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        if (SummonManager.recastFinishedHelper((ServerPlayer)serverPlayer, (RecastInstance)recastInstance, (RecastResult)recastResult, (ICastDataSerializable)castDataSerializable)) {
            super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
        }
    }

    public ICastDataSerializable getEmptyCastData() {
        return new SummonedEntitiesCastData();
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        PlayerRecasts recasts = playerMagicData.getPlayerRecasts();
        if (!recasts.hasRecastForSpell((AbstractSpell)this)) {
            SummonedEntitiesCastData summonedEntitiesCastData = new SummonedEntitiesCastData();
            int summonTime = 12000;
            AttributeModifier healthModifier = new AttributeModifier(IronsSpellbooks.id((String)"spell_power_health_bonus"), this.getHealthBonus(spellLevel, entity), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            AttributeModifier damageModifier = new AttributeModifier(IronsSpellbooks.id((String)"spell_power_damage_bonus"), this.getDamageBonus(spellLevel, entity), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            int summonCount = Math.min(spellLevel, 7);
            for (int i = 0; i < summonCount; ++i) {
                SummonedTerraprisma terraprisma = new SummonedTerraprisma(world, entity);
                terraprisma.moveTo(entity.position().add(0.0, 1.2, 0.0).add(Utils.getRandomVec3((double)1.0)));
                terraprisma.getAttribute(Attributes.ATTACK_DAMAGE).addPermanentModifier(damageModifier);
                terraprisma.getAttribute(Attributes.MAX_HEALTH).addPermanentModifier(healthModifier);
                terraprisma.setHealth(terraprisma.getMaxHealth());
                SummonedTerraprisma creature = (SummonedTerraprisma)((SpellSummonEvent)NeoForge.EVENT_BUS.post((Event)new SpellSummonEvent(entity, (LivingEntity)terraprisma, this.spellId, spellLevel))).getCreature();
                world.addFreshEntity((Entity)creature);
                SummonManager.initSummon((Entity)entity, (Entity)creature, (int)summonTime, (SummonedEntitiesCastData)summonedEntitiesCastData);
            }
            RecastInstance recastInstance = new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), summonTime, castSource, (ICastDataSerializable)summonedEntitiesCastData);
            recasts.addRecast(recastInstance, playerMagicData);
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }
}

