/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Spells.Ice;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.hazen.hazennstuff.Entity.Spells.Ice.IceArrow.CrystalVolley.CrystalVolley;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class CrystalVolleySpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"hazennstuff", (String)"crystal_volley");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(10).setCooldownSeconds(16.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.translatable((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(caster), (int)1)}));
    }

    public CrystalVolleySpell() {
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 1;
        this.castTime = 160;
        this.baseManaCost = 5;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.ENDER_CAST.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!(playerMagicData.getAdditionalCastData() instanceof StarfallCastData)) {
            Vec3 targetArea = Utils.moveToRelativeGroundLevel((Level)world, (Vec3)Utils.raycastForEntity((Level)world, (Entity)entity, (float)40.0f, (boolean)true).getLocation(), (int)12);
            playerMagicData.setAdditionalCastData((ICastData)new StarfallCastData(targetArea));
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public static void particleTrail(Level level, Vec3 a, Vec3 b, ParticleOptions particleType) {
        double d = a.distanceTo(b) * 4.0;
        int i = 0;
        while ((double)i < d) {
            double p = (double)i / d;
            Vec3 vec = a.add(b.subtract(a).scale(p));
            MagicManager.spawnParticles((Level)level, (ParticleOptions)particleType, (double)vec.x, (double)vec.y, (double)vec.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            ++i;
        }
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        ICastData iCastData;
        if (playerMagicData == null || !((iCastData = playerMagicData.getAdditionalCastData()) instanceof StarfallCastData)) {
            return;
        }
        StarfallCastData castData = (StarfallCastData)iCastData;
        float radius = this.getRadius(entity);
        int tick = playerMagicData.getCastDurationRemaining() - 1;
        if (tick % 20 == 0) {
            castData.updateTrackedEntities(level.getEntities((Entity)entity, AABB.ofSize((Vec3)castData.center, (double)(radius * 3.0f), (double)radius, (double)(radius * 3.0f)), e -> e instanceof LivingEntity && !DamageSources.isFriendlyFireBetween((Entity)entity, (Entity)e)));
        }
        if (tick % 4 == 0) {
            for (int i = 0; i < 2; ++i) {
                Vec3 center = castData.center;
                Vec3 weightedArea = Vec3.ZERO;
                for (Entity target : castData.trackedEntities) {
                    weightedArea = weightedArea.add(target.position().subtract(center).scale((double)(1.0f / (float)castData.trackedEntities.size())));
                }
                double spawnRadius = Mth.clampedLerp((double)radius, (double)((double)radius * 0.5), (double)(weightedArea.length() / (double)radius));
                Vec3 spawnTarget = Utils.moveToRelativeGroundLevel((Level)level, (Vec3)center.add(weightedArea).add(new Vec3(0.0, 0.0, (double)entity.getRandom().nextFloat() * spawnRadius).yRot((float)entity.getRandom().nextInt(360) * ((float)Math.PI / 180))), (int)3).add(0.0, 0.5, 0.0);
                Vec3 trajectory = new Vec3((double)0.15f, (double)-0.85f, 0.0).normalize();
                Vec3 spawn = Utils.raycastForBlock((Level)level, (Vec3)spawnTarget, (Vec3)spawnTarget.add(trajectory.scale(-12.0)), (ClipContext.Fluid)ClipContext.Fluid.NONE).getLocation().add(trajectory);
                this.shootIceArrow(level, spellLevel, entity, spawn, trajectory);
                MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)spawn.x, (double)spawn.y, (double)spawn.z, (int)1, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (boolean)false);
                MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.SNOW_DUST, (double)spawn.x, (double)spawn.y, (double)spawn.z, (int)1, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (boolean)true);
            }
        }
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 0.5f;
    }

    private float getRadius(LivingEntity caster) {
        return 6.0f;
    }

    public void shootIceArrow(Level world, int spellLevel, LivingEntity entity, Vec3 spawn, Vec3 trajectory) {
        CrystalVolley crystalVolley = new CrystalVolley(world, entity);
        crystalVolley.setPos(spawn.add(-1.0, 0.0, 0.0));
        Vec3 dir = trajectory.normalize();
        crystalVolley.shoot(dir.x, dir.y, dir.z, 1.5f, 0.0f);
        crystalVolley.setDamage(this.getDamage(spellLevel, entity));
        crystalVolley.setExplosionRadius(2.0f);
        world.addFreshEntity((Entity)crystalVolley);
        world.playSound(null, spawn.x, spawn.y, spawn.z, SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.PLAYERS, 3.0f, 0.7f + Utils.random.nextFloat() * 0.3f);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ANIMATION_CONTINUOUS_OVERHEAD;
    }

    public SpellDamageSource getDamageSource(@Nullable Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setFreezeTicks(80);
    }

    public static class StarfallCastData
    implements ICastData {
        Vec3 center;
        final List<Entity> trackedEntities = new ArrayList<Entity>();

        public StarfallCastData(Vec3 center) {
            this.center = center;
        }

        public void reset() {
            this.trackedEntities.clear();
        }

        public void updateTrackedEntities(List<Entity> entities) {
            this.trackedEntities.clear();
            this.trackedEntities.addAll(entities);
        }
    }
}

