/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Spells.Fire;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.particle.FlameStrikeParticleOptions;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.hazen.hazennstuff.Entity.Spells.Fire.ImmolatingObliterator.ScorchingSlash;
import net.hazen.hazennstuff.Registries.HnSEntityRegistry;
import net.hazen.hazennstuff.Spells.AbstractRavensBaneSpell;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class ScorchingSlashSpell
extends AbstractRavensBaneSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"hazennstuff", (String)"scorching_slash");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(3).setCooldownSeconds(15.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{this.getDamageText(spellLevel, caster)}));
    }

    @Override
    public boolean allowLooting() {
        return false;
    }

    public ScorchingSlashSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 2;
        this.castTime = 10;
        this.baseManaCost = 30;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.FLAMING_STRIKE_UPSWING.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.FLAMING_STRIKE_SWING.get());
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ONE_HANDED_HORIZONTAL_SWING_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float radius = 3.25f;
        float distance = 1.9f;
        Vec3 forward = entity.getForward();
        Vec3 hitLocation = entity.position().add(0.0, (double)(entity.getBbHeight() * 0.3f), 0.0).add(forward.scale((double)distance));
        List entities = level.getEntities((Entity)entity, AABB.ofSize((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        SpellDamageSource damageSource = this.getDamageSource((Entity)entity);
        for (Entity targetEntity : entities) {
            Vec3 offsetVector;
            if (!(targetEntity instanceof LivingEntity) || !targetEntity.isAlive() || !entity.isPickable() || !(targetEntity.position().subtract(entity.getEyePosition()).dot(forward) >= 0.0) || !(entity.distanceToSqr(targetEntity) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.getEyePosition(), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)true) || !((offsetVector = targetEntity.getBoundingBox().getCenter().subtract(entity.getEyePosition())).dot(forward) >= 0.0) || !DamageSources.applyDamage((Entity)targetEntity, (float)this.getDamage(spellLevel, entity), (DamageSource)damageSource)) continue;
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.FIRE, (double)targetEntity.getX(), (double)(targetEntity.getY() + (double)(targetEntity.getBbHeight() * 0.5f)), (double)targetEntity.getZ(), (int)30, (double)(targetEntity.getBbWidth() * 0.5f), (double)(targetEntity.getBbHeight() * 0.5f), (double)(targetEntity.getBbWidth() * 0.5f), (double)0.03, (boolean)false);
            EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)level), (Entity)targetEntity, (DamageSource)damageSource);
        }
        if (!level.isClientSide) {
            ScorchingSlash projectile = new ScorchingSlash((EntityType<? extends Projectile>)((EntityType)HnSEntityRegistry.SCORCHING_SLASH.get()), level);
            projectile.setOwner((Entity)entity);
            projectile.setPos(entity.getX(), entity.getEyeY() - 0.2, entity.getZ());
            projectile.shoot(entity.getLookAngle().x, entity.getLookAngle().y, entity.getLookAngle().z, 1.6f, 0.05f);
            projectile.setDamage(this.getDamage(spellLevel, entity));
            level.addFreshEntity((Entity)projectile);
        }
        boolean mirrored = playerMagicData.getCastingEquipmentSlot().equals(SpellSelectionManager.OFFHAND);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new FlameStrikeParticleOptions((float)forward.x, (float)forward.y, (float)forward.z, mirrored, false, 1.0f), (double)hitLocation.x, (double)(hitLocation.y + 0.3), (double)hitLocation.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getAdditionalDamage(LivingEntity entity) {
        if (entity == null) {
            return 0.0f;
        }
        float weaponDamage = Utils.getWeaponDamage((LivingEntity)entity);
        ItemStack weaponItem = entity.getWeaponItem();
        if (!weaponItem.isEmpty() && weaponItem.has(DataComponents.ENCHANTMENTS)) {
            weaponDamage += (float)Utils.getEnchantmentLevel((Level)entity.level(), (ResourceKey)Enchantments.FIRE_ASPECT, (ItemEnchantments)((ItemEnchantments)weaponItem.get(DataComponents.ENCHANTMENTS)));
        }
        return weaponDamage;
    }

    private String getDamageText(int spellLevel, LivingEntity entity) {
        if (entity != null) {
            float weaponDamage = Utils.getWeaponDamage((LivingEntity)entity);
            String plus = "";
            if (weaponDamage > 0.0f) {
                plus = String.format(" (+%s)", Utils.stringTruncation((double)weaponDamage, (int)1));
            }
            String damage = Utils.stringTruncation((double)this.getDamage(spellLevel, entity), (int)1);
            return damage + plus;
        }
        float var10000 = this.getSpellPower(spellLevel, (Entity)entity);
        return "" + var10000;
    }

    public float getDamage(int spellLevel, LivingEntity caster) {
        return 5.0f + this.getSpellPower(spellLevel, (Entity)caster) * 0.7f + this.getAdditionalDamage(caster);
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setFireTicks(90);
    }
}

