/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Spells.Fire;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import java.util.List;
import net.hazen.hazennstuff.Datagen.HnSTags;
import net.hazen.hazennstuff.Entity.Spells.Fire.FireDaggers.FieryDaggerMagicProjectile;
import net.hazen.hazennstuff.Spells.HnSSpellAnimations;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;

@AutoSpellConfig
public class FieryDaggerSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"hazennstuff", (String)"fiery_dagger");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(5).setCooldownSeconds(8.0).setAllowCrafting(false).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}));
    }

    public boolean allowLooting() {
        return false;
    }

    public FieryDaggerSpell() {
        this.manaCostPerLevel = 2;
        this.baseSpellPower = 12;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 10;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public AnimationHolder getCastFinishAnimation() {
        return HnSSpellAnimations.FIERY_DAGGER_CAST;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (world.isClientSide) {
            return;
        }
        Vec3 look = entity.getLookAngle();
        boolean hasCinderousEquipment = this.hasTaggedItem(entity, HnSTags.CINDEROUS_EQUIPMENT);
        if (hasCinderousEquipment) {
            int[] angles;
            float explosionRadius = 1.0f + (float)spellLevel * 0.5f;
            for (int angle : angles = new int[]{0, -15, 15}) {
                FieryDaggerMagicProjectile dagger = new FieryDaggerMagicProjectile(world);
                dagger.setOwner((Entity)entity);
                dagger.setDamage(this.getDamage(spellLevel, entity));
                dagger.setExplosionRadius(explosionRadius);
                dagger.setPos(entity.position().add(0.0, (double)entity.getEyeHeight() - (double)dagger.getBbHeight() * 0.5, 0.0));
                Vec3 dir = look.yRot((float)Math.toRadians(angle));
                dagger.shoot(dir.x, dir.y, dir.z, 1.25f, 0.0f);
                dagger.setNoGravity(false);
                world.addFreshEntity((Entity)dagger);
            }
        } else {
            int count = 8;
            double arcAngle = Math.toRadians(120.0);
            double radius = 1.6;
            double height = 1.2;
            int baseDelay = 10;
            int delayBetween = 2;
            Vec3 forward = entity.getLookAngle().normalize();
            Vec3 up = new Vec3(0.0, 1.0, 0.0);
            Vec3 right = forward.cross(up).normalize();
            up = right.cross(forward).normalize();
            Vec3 arcCenter = entity.position().add(0.0, (double)entity.getEyeHeight() + height, 0.0).add(forward.scale(0.5));
            for (int i = 0; i < count; ++i) {
                double t = (double)i / (double)(count - 1);
                double angle = -arcAngle / 2.0 + t * arcAngle;
                Vec3 offset = right.scale(Math.sin(angle) * radius).add(up.scale(Math.cos(angle) * radius * 0.7));
                Vec3 spawnPos = arcCenter.add(offset);
                FieryDaggerMagicProjectile dagger = new FieryDaggerMagicProjectile(world);
                dagger.setOwner((Entity)entity);
                dagger.setDamage(this.getDamage(spellLevel, entity));
                dagger.setExplosionRadius(0.0f);
                dagger.setPos(spawnPos);
                dagger.launchDir = forward;
                dagger.ownerTrack = spawnPos.subtract(entity.position());
                dagger.setDeltaMovement(0.0, 0.0, 0.0);
                dagger.delay = baseDelay + i * delayBetween;
                world.addFreshEntity((Entity)dagger);
            }
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private boolean hasTaggedItem(LivingEntity entity, TagKey<Item> tag) {
        if (entity.getMainHandItem().is(tag) || entity.getOffhandItem().is(tag)) {
            return true;
        }
        for (ItemStack armor : entity.getArmorSlots()) {
            if (!armor.is(tag)) continue;
            return true;
        }
        boolean hasCurio = CuriosApi.getCuriosInventory((LivingEntity)entity).map(curios -> !curios.findCurios(item -> item != null && item.is(tag)).isEmpty()).orElse(false);
        return hasCurio;
    }

    public SpellDamageSource getDamageSource(@Nullable Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setFireTicks(60);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) * 0.5f;
    }
}

