/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Registries.Effects;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.effect.ISyncedMobEffect;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.hazen.hazennstuff.Registries.HnSAttributeRegistry;
import net.hazen.hazennstuff.Registries.HnSEffects;
import net.hazen.hazennstuff.Registries.HnSParticleHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class InfestedEffect
extends MagicMobEffect
implements ISyncedMobEffect {
    public static final int STACKS_REQUIRED = 3;
    public static final int STACKS_REQUIRED_AMPLIFIER = 2;
    private static final Map<LivingEntity, Entity> EFFECT_CREDIT = new WeakHashMap<LivingEntity, Entity>();
    private static final Map<MobEffectInstance, Integer> DELAYED_INSTANCES = new WeakHashMap<MobEffectInstance, Integer>();
    static int duration;

    public InfestedEffect(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public static MobEffectInstance addInfestedStack(LivingEntity entity, @Nullable Entity afflicter) {
        MobEffectInstance previous = entity.getEffect(HnSEffects.INFESTED);
        MobEffectInstance inst = previous != null ? new MobEffectInstance(HnSEffects.INFESTED, 300, previous.getAmplifier() + 1, previous.isAmbient(), previous.isVisible(), previous.showIcon()) : new MobEffectInstance(HnSEffects.INFESTED, 300, 0, false, false, true);
        if (afflicter != null) {
            EFFECT_CREDIT.put(entity, afflicter);
        }
        entity.addEffect(inst);
        return inst;
    }

    public void clientTick(LivingEntity livingEntity, MobEffectInstance instance) {
        int amplifier = instance.getAmplifier();
        ParticleOptions particle = HnSParticleHelper.MUSHROOM_PARTICLE;
        if (amplifier >= 1) {
            particle = HnSParticleHelper.MUSHROOM_FOG;
        }
        RandomSource random = livingEntity.getRandom();
        for (int i = 0; i < 1; ++i) {
            Vec3 motion = new Vec3((double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() * 2.0f - 1.0f));
            motion = motion.scale((double)0.04f);
            livingEntity.level().addParticle(particle, livingEntity.getRandomX((double)0.4f), livingEntity.getRandomY(), livingEntity.getRandomZ((double)0.4f), motion.x, motion.y, motion.z);
        }
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance self = livingEntity.getEffect(HnSEffects.INFESTED);
        if (DELAYED_INSTANCES.containsKey(self) && DELAYED_INSTANCES.get(self) - duration <= 4) {
            return true;
        }
        float effectRadius = 6.0f;
        Level level = livingEntity.level();
        if (level.isClientSide) {
            return true;
        }
        @Nullable Entity attacker = EFFECT_CREDIT.remove(livingEntity);
        if (attacker == null || attacker != livingEntity) {
            livingEntity.addEffect(new MobEffectInstance(HnSEffects.SPORES, 100, 1));
        }
        List entities = level.getEntities(null, livingEntity.getBoundingBox().inflate((double)effectRadius));
        Vec3 losPoint = Utils.raycastForBlock((Level)level, (Vec3)livingEntity.position(), (Vec3)livingEntity.position().add(0.0, 1.0, 0.0), (ClipContext.Fluid)ClipContext.Fluid.NONE).getLocation();
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingVictim = (LivingEntity)entity;
            if (entity == livingEntity || entity == attacker || !entity.canBeHitByProjectile() || DamageSources.isFriendlyFireBetween((Entity)attacker, (Entity)entity) || !Utils.hasLineOfSight((Level)level, (Vec3)losPoint, (Vec3)entity.getBoundingBox().getCenter(), (boolean)true)) continue;
            livingVictim.addEffect(new MobEffectInstance(HnSEffects.SPORES, 100, 1));
        }
        return false;
    }

    public static double damageFor(@Nullable Entity entity) {
        double baseDamage = 10.0;
        if (entity instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)entity;
            baseDamage = baseDamage * livingAttacker.getAttributeValue((Holder)AttributeRegistry.SPELL_POWER) * livingAttacker.getAttributeValue(HnSAttributeRegistry.RADIANCE_MAGIC_POWER);
        }
        return baseDamage;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        InfestedEffect.duration = duration;
        return amplifier >= 2;
    }
}

