/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Weapons.VampireKnives;

import io.redspace.ironsspellbooks.api.events.ModifySpellLevelEvent;
import io.redspace.ironsspellbooks.api.item.curios.AffinityData;
import io.redspace.ironsspellbooks.api.item.weapons.ExtendedSwordItem;
import io.redspace.ironsspellbooks.api.item.weapons.MagicSwordItem;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.item.weapons.IronsWeaponTier;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.hazen.hazennstuff.Entity.Spells.Blood.LifestealKnife.VampireKnife;
import net.hazen.hazennstuff.Item.Weapons.HnSExtendedWeaponsTiers;
import net.hazen.hazennstuff.Item.Weapons.VampireKnives.VampireKnivesRenderer;
import net.hazen.hazennstuff.Rarity.HnSRarities;
import net.hazen.hazennstuff.Registries.HnSSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VampireKnivesItem
extends MagicSwordItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("idle");
    private final AnimationController<VampireKnivesItem> animationController = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate);

    public VampireKnivesItem() {
        super((Tier)HnSExtendedWeaponsTiers.VAMPIRE_KNIVES, ItemPropertiesHelper.equipment((int)1).fireResistant().rarity((Rarity)HnSRarities.BLOOD_RARITY.getValue()).attributes(ExtendedSwordItem.createAttributes((IronsWeaponTier)HnSExtendedWeaponsTiers.VAMPIRE_KNIVES)), SpellDataRegistryHolder.of((SpellDataRegistryHolder[])new SpellDataRegistryHolder[]{new SpellDataRegistryHolder(SpellRegistry.BLOOD_NEEDLES_SPELL, 5)}));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    private PlayState predicate(AnimationState<VampireKnivesItem> event) {
        event.getController().setAnimation(IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private VampireKnivesRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new VampireKnivesRenderer();
                }
                return this.renderer;
            }
        });
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            ItemStack stack = player.getItemInHand(hand);
            Vec3 look = player.getLookAngle();
            double spread = 0.2;
            for (int i = 0; i < 5; ++i) {
                double xPower = look.x + level.random.nextGaussian() * spread;
                double yPower = look.y + level.random.nextGaussian() * spread;
                double zPower = look.z + level.random.nextGaussian() * spread;
                VampireKnife projectile = new VampireKnife(level, (LivingEntity)player);
                projectile.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
                projectile.shoot(xPower, yPower, zPower, 1.5f, 0.0f);
                level.addFreshEntity((Entity)projectile);
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), HnSSounds.VAMPIRE_KNIFE_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.getCooldowns().addCooldown((Item)this, 40);
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide());
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, lines, flag);
        AffinityData affinityData = AffinityData.getAffinityData((ItemStack)stack);
        if (!affinityData.affinityData().isEmpty()) {
            int i = TooltipsUtils.indexOfComponent(lines, (String)"tooltip.hazennstuff.spellbook_spell_count");
            lines.addAll(i < 0 ? lines.size() : i + 1, affinityData.getDescriptionComponent());
        }
        lines.add((Component)Component.translatable((String)"item.hazennstuff.vampire_knives.description").withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.ITALIC}));
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        super.initializeSpellContainer(itemStack);
        itemStack.set((Supplier)ComponentRegistry.AFFINITY_COMPONENT, (Object)new AffinityData(Map.of(((AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get()).getSpellResource(), 1)));
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public class SpellEvents {
        public SpellEvents(VampireKnivesItem this$0) {
        }

        @SubscribeEvent
        public static void onModifySpellLevel(ModifySpellLevelEvent event) {
            boolean usingKnives;
            LivingEntity caster = event.getEntity();
            if (caster == null) {
                return;
            }
            if (event.getSpell() != SpellRegistry.BLOOD_NEEDLES_SPELL.get()) {
                return;
            }
            ItemStack mainHand = caster.getMainHandItem();
            ItemStack offHand = caster.getOffhandItem();
            boolean bl = usingKnives = mainHand.getItem() instanceof VampireKnivesItem || offHand.getItem() instanceof VampireKnivesItem;
            if (usingKnives) {
                event.addLevels(1);
            }
        }
    }
}

