/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Weapons.Skyscorcher;

import io.redspace.ironsspellbooks.api.events.ModifySpellLevelEvent;
import io.redspace.ironsspellbooks.api.item.curios.AffinityData;
import io.redspace.ironsspellbooks.api.item.weapons.ExtendedSwordItem;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.item.weapons.IronsWeaponTier;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.hazen.hazennstuff.Item.Weapons.HnSExtendedWeaponsTiers;
import net.hazen.hazennstuff.Item.Weapons.Skyscorcher.SkyscorcherRenderer;
import net.hazen.hazennstuff.Rarity.HnSRarities;
import net.hazen.hazennstuff.Registries.HnSExtras.MagicMace.MagicMaceItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SkyscorcherItem
extends MagicMaceItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("idle");
    private final AnimationController<SkyscorcherItem> animationController = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate);

    public SkyscorcherItem() {
        super(HnSExtendedWeaponsTiers.SKYSCORCHER, ItemPropertiesHelper.equipment((int)1).fireResistant().rarity((Rarity)HnSRarities.LIGHTNING_RARITY.getValue()).attributes(ExtendedSwordItem.createAttributes((IronsWeaponTier)HnSExtendedWeaponsTiers.SKYSCORCHER)).component(DataComponents.TOOL, (Object)MaceItem.createToolProperties()), SpellDataRegistryHolder.of((SpellDataRegistryHolder[])new SpellDataRegistryHolder[]{new SpellDataRegistryHolder(SpellRegistry.VOLT_STRIKE_SPELL, 5)}));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide) {
            attacker.level().playSound(null, target.getX(), target.getY(), target.getZ(), (Holder)SoundRegistry.SPEAR_CHANNELING_STRIKE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    private PlayState predicate(AnimationState<SkyscorcherItem> event) {
        event.getController().setAnimation(IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private SkyscorcherRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new SkyscorcherRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, lines, flag);
        AffinityData affinityData = AffinityData.getAffinityData((ItemStack)stack);
        if (!affinityData.affinityData().isEmpty()) {
            int i = TooltipsUtils.indexOfComponent(lines, (String)"tooltip.hazennstuff.spellbook_spell_count");
            lines.addAll(i < 0 ? lines.size() : i + 1, affinityData.getDescriptionComponent());
        }
        lines.add((Component)Component.translatable((String)"item.hazennstuff.skyscorcher.description").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
    }

    @Override
    public void initializeSpellContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        super.initializeSpellContainer(itemStack);
        itemStack.set((Supplier)ComponentRegistry.AFFINITY_COMPONENT, (Object)new AffinityData(Map.of(((AbstractSpell)SpellRegistry.VOLT_STRIKE_SPELL.get()).getSpellResource(), 1)));
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public class SpellEvents {
        public SpellEvents(SkyscorcherItem this$0) {
        }

        @SubscribeEvent
        public static void onModifySpellLevel(ModifySpellLevelEvent event) {
            boolean usingKnives;
            LivingEntity caster = event.getEntity();
            if (caster == null) {
                return;
            }
            if (event.getSpell() != SpellRegistry.VOLT_STRIKE_SPELL.get()) {
                return;
            }
            ItemStack mainHand = caster.getMainHandItem();
            ItemStack offHand = caster.getOffhandItem();
            boolean bl = usingKnives = mainHand.getItem() instanceof SkyscorcherItem || offHand.getItem() instanceof SkyscorcherItem;
            if (usingKnives) {
                event.addLevels(1);
            }
        }
    }
}

