/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Weapons.Meowmere;

import io.redspace.ironsspellbooks.api.item.weapons.ExtendedSwordItem;
import io.redspace.ironsspellbooks.item.weapons.IronsWeaponTier;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.hazen.hazennstuff.Item.Weapons.HnSExtendedWeaponsTiers;
import net.hazen.hazennstuff.Item.Weapons.Meowmere.MeowmereRenderer;
import net.hazen.hazennstuff.Rarity.HnSRarities;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MeowmereItem
extends ExtendedSwordItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("idle");
    private final AnimationController<MeowmereItem> animationController = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate);

    public MeowmereItem() {
        super((Tier)HnSExtendedWeaponsTiers.MEOWMERE, ItemPropertiesHelper.equipment((int)1).fireResistant().rarity((Rarity)HnSRarities.RADIANCE_RARITY.getValue()).attributes(ExtendedSwordItem.createAttributes((IronsWeaponTier)HnSExtendedWeaponsTiers.MEOWMERE)));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, lines, flag);
        lines.add((Component)Component.translatable((String)"item.hazennstuff.terraria.description").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}));
    }

    public Component getName(ItemStack stack) {
        String baseName = super.getName(stack).getString();
        MutableComponent rainbowName = Component.literal((String)"");
        Minecraft mc = Minecraft.getInstance();
        long ticks = mc.level != null ? mc.level.getGameTime() : 0L;
        for (int i = 0; i < baseName.length(); ++i) {
            float hue = ((float)(i * 40) + (float)ticks * 2.25f) % 360.0f / 360.0f;
            int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            String hex = String.format("#%06X", 0xFFFFFF & rgb);
            TextColor color = (TextColor)TextColor.parseColor((String)hex).getOrThrow();
            rainbowName = rainbowName.append((Component)Component.literal((String)String.valueOf(baseName.charAt(i))).withStyle(style -> style.withColor(color)));
        }
        return rainbowName;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    private PlayState predicate(AnimationState<MeowmereItem> event) {
        event.getController().setAnimation(IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private MeowmereRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new MeowmereRenderer();
                }
                return this.renderer;
            }
        });
    }
}

