/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Weapons.HammerOfJustice;

import io.redspace.ironsspellbooks.api.events.ModifySpellLevelEvent;
import io.redspace.ironsspellbooks.api.item.curios.AffinityData;
import io.redspace.ironsspellbooks.api.item.weapons.ExtendedSwordItem;
import io.redspace.ironsspellbooks.api.item.weapons.MagicSwordItem;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.item.weapons.IronsWeaponTier;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.hazen.hazennstuff.Dispatcher.HnSDispatcher;
import net.hazen.hazennstuff.Item.Weapons.HnSExtendedWeaponsTiers;
import net.hazen.hazennstuff.Rarity.HnSRarities;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;

public class HammerOfJusticeItem
extends MagicSwordItem {
    public final HnSDispatcher dispatcher = new HnSDispatcher();

    public HammerOfJusticeItem() {
        super((Tier)HnSExtendedWeaponsTiers.HAMMER_OF_JUSTICE, ItemPropertiesHelper.equipment((int)1).fireResistant().rarity((Rarity)HnSRarities.HOLY_RARITY.getValue()).attributes(ExtendedSwordItem.createAttributes((IronsWeaponTier)HnSExtendedWeaponsTiers.HAMMER_OF_JUSTICE)), SpellDataRegistryHolder.of((SpellDataRegistryHolder[])new SpellDataRegistryHolder[]{new SpellDataRegistryHolder(SpellRegistry.DIVINE_SMITE_SPELL, 10)}));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            this.dispatcher.idle((Entity)player, stack);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, lines, flag);
        AffinityData affinityData = AffinityData.getAffinityData((ItemStack)stack);
        if (!affinityData.affinityData().isEmpty()) {
            int i = TooltipsUtils.indexOfComponent(lines, (String)"tooltip.hazennstuff.spellbook_spell_count");
            lines.addAll(i < 0 ? lines.size() : i + 1, affinityData.getDescriptionComponent());
        }
        lines.add((Component)Component.translatable((String)"item.hazennstuff.cat.description").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC}));
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        super.initializeSpellContainer(itemStack);
        itemStack.set((Supplier)ComponentRegistry.AFFINITY_COMPONENT, (Object)new AffinityData(Map.of(((AbstractSpell)SpellRegistry.DIVINE_SMITE_SPELL.get()).getSpellResource(), 1)));
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public class SpellEvents {
        public SpellEvents(HammerOfJusticeItem this$0) {
        }

        @SubscribeEvent
        public static void onModifySpellLevel(ModifySpellLevelEvent event) {
            boolean usingKnives;
            LivingEntity caster = event.getEntity();
            if (caster == null) {
                return;
            }
            if (event.getSpell() != SpellRegistry.DIVINE_SMITE_SPELL.get()) {
                return;
            }
            ItemStack mainHand = caster.getMainHandItem();
            ItemStack offHand = caster.getOffhandItem();
            boolean bl = usingKnives = mainHand.getItem() instanceof HammerOfJusticeItem || offHand.getItem() instanceof HammerOfJusticeItem;
            if (usingKnives) {
                event.addLevels(1);
            }
        }
    }
}

