/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Util.SpectralPickaxe;

import io.redspace.ironsspellbooks.api.events.ModifySpellLevelEvent;
import io.redspace.ironsspellbooks.api.item.curios.AffinityData;
import io.redspace.ironsspellbooks.api.item.weapons.ExtendedSwordItem;
import io.redspace.ironsspellbooks.api.item.weapons.MagicSwordItem;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.item.weapons.IronsWeaponTier;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.hazen.hazennstuff.Item.Util.HnSToolTiers;
import net.hazen.hazennstuff.Item.Util.SpectralPickaxe.SpectralPickaxeRenderer;
import net.hazen.hazennstuff.Item.Weapons.HnSExtendedWeaponsTiers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SpectralPickaxeItem
extends MagicSwordItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("idle");
    private final AnimationController<SpectralPickaxeItem> animationController = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate);

    public SpectralPickaxeItem() {
        super((Tier)HnSExtendedWeaponsTiers.SPECTRAL_PICKAXE, ItemPropertiesHelper.equipment((int)1).fireResistant().rarity(Rarity.EPIC).attributes(ExtendedSwordItem.createAttributes((IronsWeaponTier)HnSExtendedWeaponsTiers.DIVINE_GREATSWORD)).component(DataComponents.TOOL, (Object)HnSToolTiers.MITHRIL.createToolProperties(BlockTags.MINEABLE_WITH_PICKAXE)), SpellDataRegistryHolder.of((SpellDataRegistryHolder[])new SpellDataRegistryHolder[]{new SpellDataRegistryHolder(SpellRegistry.SPECTRAL_HAMMER_SPELL, 3)}));
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.is(BlockTags.MINEABLE_WITH_PICKAXE);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            return HnSToolTiers.MITHRIL.getSpeed();
        }
        return 1.0f;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    private PlayState predicate(AnimationState<SpectralPickaxeItem> event) {
        event.getController().setAnimation(IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private SpectralPickaxeRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new SpectralPickaxeRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, lines, flag);
        AffinityData affinityData = AffinityData.getAffinityData((ItemStack)itemStack);
        if (!affinityData.affinityData().isEmpty()) {
            int i = TooltipsUtils.indexOfComponent(lines, (String)"tooltip.hazennstuff.spellbook_spell_count");
            lines.addAll(i < 0 ? lines.size() : i + 1, affinityData.getDescriptionComponent());
        }
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        super.initializeSpellContainer(itemStack);
        itemStack.set((Supplier)ComponentRegistry.AFFINITY_COMPONENT, (Object)new AffinityData(Map.of(((AbstractSpell)SpellRegistry.SPECTRAL_HAMMER_SPELL.get()).getSpellResource(), 1)));
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public class SpellEvents {
        public SpellEvents(SpectralPickaxeItem this$0) {
        }

        @SubscribeEvent
        public static void onModifySpellLevel(ModifySpellLevelEvent event) {
            boolean usingSpectralPickaxe;
            LivingEntity caster = event.getEntity();
            if (caster == null) {
                return;
            }
            if (event.getSpell() != SpellRegistry.SPECTRAL_HAMMER_SPELL.get()) {
                return;
            }
            ItemStack mainHand = caster.getMainHandItem();
            ItemStack offHand = caster.getOffhandItem();
            boolean bl = usingSpectralPickaxe = mainHand.getItem() instanceof SpectralPickaxeItem || offHand.getItem() instanceof SpectralPickaxeItem;
            if (usingSpectralPickaxe) {
                event.addLevels(1);
            }
        }
    }
}

