/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Curios.Wings.ArbitriumWings;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.util.List;
import net.hazen.hazennstuff.Dispatcher.HnSDispatcher;
import net.hazen.hazennstuff.Rarity.HnSRarities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class ArbitriumWings
extends CurioBaseItem {
    public final HnSDispatcher dispatcher = new HnSDispatcher();
    private static final int GLIDE_ANIMATION = 0;

    public ArbitriumWings() {
        super(ItemPropertiesHelper.equipment().stacksTo(1).fireResistant().rarity((Rarity)HnSRarities.HOLY_RARITY.getValue()));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, lines, flag);
        lines.add((Component)Component.translatable((String)"item.hazennstuff.arbitrium_robes.description").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}));
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap attr = LinkedHashMultimap.create();
        attr.put((Object)ALObjects.Attributes.ELYTRA_FLIGHT, (Object)new AttributeModifier(id, 1.0, AttributeModifier.Operation.ADD_VALUE));
        return attr;
    }

    private void handleFlightState(Player player, ItemStack stack) {
        this.dispatcher.flight((Entity)player, stack);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block7: {
            block6: {
                LivingEntity entity = slotContext.entity();
                if (!(entity instanceof Player)) break block6;
                player = (Player)entity;
                if (!player.level().isClientSide) break block7;
            }
            return;
        }
        if (!player.level().isClientSide && player.isFallFlying()) {
            this.elytraFlightTick(stack, (LivingEntity)player, 0);
        }
        if (player.isFallFlying()) {
            this.handleFlightState(player, stack);
            player.fallDistance = 0.0f;
        } else {
            this.dispatcher.idle((Entity)player, stack);
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }
}

