/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Curios.Spellbooks.EnergizedCoreSpellbook;

import io.redspace.ironsspellbooks.api.item.curios.AffinityData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import java.util.Map;
import net.hazen.hazennstuff.Dispatcher.HnSDispatcher;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EnergizedCoreSpellbook
extends SpellBook {
    public final HnSDispatcher dispatcher;

    public EnergizedCoreSpellbook() {
        super(10);
        this.withSpellbookAttributes(new AttributeContainer[]{new AttributeContainer((Holder)AttributeRegistry.LIGHTNING_SPELL_POWER, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeContainer((Holder)AttributeRegistry.MAX_MANA, 200.0, AttributeModifier.Operation.ADD_VALUE)});
        this.dispatcher = new HnSDispatcher();
    }

    public void appendHoverText(@NotNull ItemStack itemStack, Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, lines, flag);
        AffinityData affinityData = AffinityData.getAffinityData((ItemStack)itemStack);
        if (!affinityData.affinityData().isEmpty()) {
            int i = TooltipsUtils.indexOfComponent(lines, (String)"tooltip.irons_spellbooks.spellbook_spell_count");
            lines.addAll(i < 0 ? lines.size() : i + 1, affinityData.getDescriptionComponent());
        }
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        if (itemStack != null) {
            super.initializeSpellContainer(itemStack);
            AffinityData.set((ItemStack)itemStack, (AffinityData)new AffinityData(Map.of(((AbstractSpell)SpellRegistry.THUNDERSTORM_SPELL.get()).getSpellResource(), 1, ((AbstractSpell)SpellRegistry.SHOCKWAVE_SPELL.get()).getSpellResource(), 1, ((AbstractSpell)SpellRegistry.VOLT_STRIKE_SPELL.get()).getSpellResource(), 1)));
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            this.dispatcher.idle((Entity)player, stack);
        }
    }
}

