/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Curios.Sheaths.ScrollSheath;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import net.acetheeldritchking.aces_spell_utils.items.curios.SheathCurioItem;
import net.hazen.hazennstuff.Dispatcher.HnSDispatcher;
import net.hazen.hazennstuff.HazenNStuff;
import net.hazen.hazennstuff.HnSConfig;
import net.hazen.hazennstuff.Registries.HnSEffects;
import net.hazen.hazennstuff.Registries.HnSItems;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class ScrollSheath
extends SheathCurioItem {
    public final HnSDispatcher dispatcher = new HnSDispatcher();
    public static int COOLDOWN = HnSConfig.scrollSheathCooldown * 20;
    private static final int GLIDE_ANIMATION = 0;

    public ScrollSheath() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC).fireResistant(), null);
    }

    protected int getCooldownTicks() {
        return HnSConfig.scrollSheathCooldown * 20;
    }

    @SubscribeEvent
    public static void handleAbility(LivingIncomingDamageEvent event) {
        ServerPlayer player;
        ScrollSheath sheath = (ScrollSheath)((Object)HnSItems.SCROLL_SHEATH.get());
        Entity attacker = event.getSource().getEntity();
        if (attacker instanceof ServerPlayer && sheath.isEquippedBy((LivingEntity)(player = (ServerPlayer)attacker)) && sheath.tryProcCooldown((Player)player)) {
            LivingEntity victim = event.getEntity();
            float getBaseDamage = event.getOriginalAmount();
            if (victim instanceof LivingEntity) {
                LivingEntity livingVictim = victim;
                if (victim != attacker) {
                    if (livingVictim.hasEffect(HnSEffects.MANA_SICKNESS)) {
                        event.setAmount(getBaseDamage * 1.5f);
                        HazenNStuff.LOGGER.debug("Damage: " + event.getAmount());
                    }
                    livingVictim.addEffect(new MobEffectInstance(HnSEffects.MANA_SICKNESS, 300, 0));
                    MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)player);
                    magicData.getPlayerCooldowns().clearCooldowns();
                    magicData.getPlayerCooldowns().syncToPlayer(player);
                    player.displayClientMessage((Component)Component.literal((String)"\u00a7bAll spell cooldowns have been refreshed!"), true);
                }
            }
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap attr = LinkedHashMultimap.create();
        attr.put((Object)AttributeRegistry.SPELL_POWER, (Object)new AttributeModifier(id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attr.put((Object)AttributeRegistry.SPELL_RESIST, (Object)new AttributeModifier(id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attr.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(id, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return attr;
    }

    private void handleFlightState(Player player, ItemStack stack) {
        this.dispatcher.flight((Entity)player, stack);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block7: {
            block6: {
                LivingEntity entity = slotContext.entity();
                if (!(entity instanceof Player)) break block6;
                player = (Player)entity;
                if (!player.level().isClientSide) break block7;
            }
            return;
        }
        if (!player.level().isClientSide && player.isFallFlying()) {
            this.elytraFlightTick(stack, (LivingEntity)player, 0);
        }
        if (player.isFallFlying()) {
            this.handleFlightState(player, stack);
            player.fallDistance = 0.0f;
        } else {
            this.dispatcher.idle((Entity)player, stack);
        }
    }
}

