/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Curios.Sheaths.GalvanizedSheath;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import net.acetheeldritchking.aces_spell_utils.items.curios.SheathCurioItem;
import net.hazen.hazennstuff.Dispatcher.HnSDispatcher;
import net.hazen.hazennstuff.Entity.Spells.Lightning.InstantLightningStrike.LightningStrike;
import net.hazen.hazennstuff.HazenNStuff;
import net.hazen.hazennstuff.HnSConfig;
import net.hazen.hazennstuff.Rarity.HnSRarities;
import net.hazen.hazennstuff.Registries.HnSEffects;
import net.hazen.hazennstuff.Registries.HnSItems;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class GalvanizedSheath
extends SheathCurioItem {
    public final HnSDispatcher dispatcher = new HnSDispatcher();
    public static int COOLDOWN = HnSConfig.galvanizedSheathCooldown * 20;

    public GalvanizedSheath() {
        super(new Item.Properties().stacksTo(1).rarity((Rarity)HnSRarities.LIGHTNING_RARITY.getValue()).fireResistant(), null);
    }

    protected int getCooldownTicks() {
        return HnSConfig.galvanizedSheathCooldown * 20;
    }

    @SubscribeEvent
    public static void handleAbility(LivingIncomingDamageEvent event) {
        LivingEntity victim;
        ServerPlayer player;
        GalvanizedSheath sheath = (GalvanizedSheath)((Object)HnSItems.GALVANIZED_SHEATH.get());
        Entity attacker = event.getSource().getEntity();
        if (attacker instanceof ServerPlayer && sheath.isEquippedBy((LivingEntity)(player = (ServerPlayer)attacker)) && sheath.tryProcCooldown((Player)player) && (victim = event.getEntity()) instanceof LivingEntity) {
            LivingEntity livingVictim = victim;
            if (victim != attacker) {
                float baseDamage = event.getOriginalAmount();
                if (livingVictim.hasEffect(HnSEffects.ELECTROCUTED)) {
                    event.setAmount(baseDamage * 1.5f);
                    HazenNStuff.LOGGER.debug("Damage: " + event.getAmount());
                }
                livingVictim.addEffect(new MobEffectInstance(HnSEffects.ELECTROCUTED, 100, 1));
                GalvanizedSheath.spawnLightningLine(player.level(), (LivingEntity)player, livingVictim);
            }
        }
    }

    private static void spawnLightningLine(Level level, LivingEntity attacker, LivingEntity victim) {
        if (level.isClientSide) {
            return;
        }
        Vec3 start = attacker.position().add(0.0, (double)attacker.getBbHeight() * 0.5, 0.0);
        Vec3 end = victim.position().add(0.0, (double)victim.getBbHeight() * 0.5, 0.0);
        Vec3 direction = end.subtract(start).normalize();
        double extraDistance = 32.0;
        double totalDistance = start.distanceTo(end) + extraDistance;
        int maxStrikes = 8;
        double stepDistance = totalDistance / (double)maxStrikes;
        Vec3 step = direction.scale(stepDistance);
        int delayPerStrike = 1;
        for (int i = 0; i < maxStrikes; ++i) {
            Vec3 pos = start.add(step.scale((double)i)).with(Direction.Axis.Y, start.y);
            LightningStrike strike = new LightningStrike(level);
            strike.setPos(pos.x, pos.y, pos.z);
            strike.setOwner((Entity)attacker);
            strike.setDamage(3.0f);
            strike.setWaitTime(i * delayPerStrike);
            level.addFreshEntity((Entity)strike);
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap attr = LinkedHashMultimap.create();
        attr.put((Object)AttributeRegistry.LIGHTNING_SPELL_POWER, (Object)new AttributeModifier(id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attr.put((Object)AttributeRegistry.LIGHTNING_MAGIC_RESIST, (Object)new AttributeModifier(id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attr.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(id, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return attr;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            this.dispatcher.idle((Entity)player, stack);
        }
    }
}

