/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Armor;

import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.hazen.hazennstuff.HazenNStuff;
import net.hazen.hazennstuff.Registries.HnSSounds;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class HnSArmorMaterials {
    private static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"hazennstuff");
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> CREAKING_SORCERER_MATERIAL = HnSArmorMaterials.register("creaking", HnSArmorMaterials.pureArmorMap(), 40, HnSSounds.CREAKING_SORCERER_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> SERAPH_MATERIAL = HnSArmorMaterials.register("seraph", HnSArmorMaterials.pureArmorMap(), 40, HnSSounds.SERAPH_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> CHARGED_SCOURGE_MATERIAL = HnSArmorMaterials.register("scourge", HnSArmorMaterials.pureArmorMap(), 40, HnSSounds.CHARGED_SCOURGE_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> SOUL_FLAME_MATERIAL = HnSArmorMaterials.register("soul_flame", HnSArmorMaterials.pureArmorMap(), 40, HnSSounds.SOUL_FLAME_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> SUPREME_WITCH_MATERIAL = HnSArmorMaterials.register("supreme_witch", HnSArmorMaterials.pureArmorMap(), 40, HnSSounds.SUPREME_WITCH_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> CRYOGENIC_RULER_MATERIAL = HnSArmorMaterials.register("cryogenic_ruler", HnSArmorMaterials.pureArmorMap(), 40, HnSSounds.CRYOGENIC_RULER_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> FLESH_MASS_MATERIAL = HnSArmorMaterials.register("flesh_mass", HnSArmorMaterials.pureArmorMap(), 40, HnSSounds.FLESH_MASS_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> ENDER_DRAGON_MATERIAL = HnSArmorMaterials.register("ender_dragon", HnSArmorMaterials.pureArmorMap(), 40, HnSSounds.ENDER_DRAGON_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> DARK_RITUAL_TEMPLAR_MATERIAL = HnSArmorMaterials.register("dark_ritual_templar", HnSArmorMaterials.battlemageArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> FIREBLOSSOM_MATERIAL = HnSArmorMaterials.register("fireblossom", HnSArmorMaterials.pureArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> CALAMITAS_MATERIAL = HnSArmorMaterials.register("calamitas", HnSArmorMaterials.pureArmorMap(), 40, HnSSounds.CALAMITAS_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> MAVERICK_MATERIAL = HnSArmorMaterials.register("maverick", HnSArmorMaterials.pureArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> SLC_CAT_MATERIAL = HnSArmorMaterials.register("slc_cat", HnSArmorMaterials.pureArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> PURE_ARMOR_TIER_MATERIAL = HnSArmorMaterials.register("pure_armor_tier", HnSArmorMaterials.pureArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> INFESTATION_MATERIAL = HnSArmorMaterials.register("infestation", HnSArmorMaterials.pureArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> BLAZEBORNE_MATERIAL = HnSArmorMaterials.register("blazeborne", HnSArmorMaterials.pureArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> LEGIONNAIRE_MATERIAL = HnSArmorMaterials.register("legionnaire", HnSArmorMaterials.pureArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> TYROS_MATERIAL = HnSArmorMaterials.register("tyros", HnSArmorMaterials.pureArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> PYRIUM_MATERIAL = HnSArmorMaterials.register("pyrium", HnSArmorMaterials.pyrium(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> WARRIOR_MATERIAL = HnSArmorMaterials.register("warrior", HnSArmorMaterials.pureArmorMap(), 40, HnSSounds.SERAPH_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> CHAMPION_MATERIAL = HnSArmorMaterials.register("champion", HnSArmorMaterials.pureArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> ARCHER_MATERIAL = HnSArmorMaterials.register("archer", HnSArmorMaterials.battlemageArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> HUNTER_MATERIAL = HnSArmorMaterials.register("hunter", HnSArmorMaterials.pureArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> DEUS_MATERIAL = HnSArmorMaterials.register("deus", HnSArmorMaterials.deityArmorMap(), 40, HnSSounds.SERAPH_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> NERFED_DEUS_MATERIAL = HnSArmorMaterials.register("nerfed_deus", HnSArmorMaterials.pureArmorMap(), 40, HnSSounds.SERAPH_EQUIP, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> BATTLEMAGE_MATERIAL = HnSArmorMaterials.register("battlemage", HnSArmorMaterials.battlemageArmorMap(), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MAGIC_CLOTH.get()}), 2.0f, 0.0f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> MAGEHUNTER_MATERIAL = HnSArmorMaterials.register("magehunter", HnSArmorMaterials.battlemageArmorMap(), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MAGIC_CLOTH.get()}), 2.0f, 0.0f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> ADVANCED_BATTLEMAGE_MATERIAL = HnSArmorMaterials.register("advanced_battlemage", HnSArmorMaterials.advancedBattlemageArmorMap(), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MAGIC_CLOTH.get()}), 2.0f, 0.0f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> AUTOMATON_MATERIAL = HnSArmorMaterials.register("automaton", HnSArmorMaterials.pureArmorMap(), 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_WEAVE.get()}), 2.0f, 0.1f);

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient, float toughness, float knockbackResistance) {
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(HazenNStuff.id(name)));
        return ARMOR_MATERIALS.register(name, () -> new ArmorMaterial((Map)defense, enchantmentValue, equipSound, repairIngredient, list, toughness, knockbackResistance));
    }

    public static EnumMap<ArmorItem.Type, Integer> makeArmorMap(int helmet, int chestplate, int leggings, int boots) {
        return (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), typeIntegerEnumMap -> {
            typeIntegerEnumMap.put(ArmorItem.Type.HELMET, helmet);
            typeIntegerEnumMap.put(ArmorItem.Type.CHESTPLATE, chestplate);
            typeIntegerEnumMap.put(ArmorItem.Type.LEGGINGS, leggings);
            typeIntegerEnumMap.put(ArmorItem.Type.BOOTS, boots);
        });
    }

    public static EnumMap<ArmorItem.Type, Integer> pureArmorMap() {
        return HnSArmorMaterials.makeArmorMap(5, 10, 8, 5);
    }

    public static EnumMap<ArmorItem.Type, Integer> battlemageArmorMap() {
        return HnSArmorMaterials.makeArmorMap(3, 8, 6, 3);
    }

    public static EnumMap<ArmorItem.Type, Integer> deityArmorMap() {
        return HnSArmorMaterials.makeArmorMap(20, 20, 20, 20);
    }

    public static EnumMap<ArmorItem.Type, Integer> advancedBattlemageArmorMap() {
        return HnSArmorMaterials.makeArmorMap(4, 6, 9, 4);
    }

    public static EnumMap<ArmorItem.Type, Integer> pyrium() {
        return HnSArmorMaterials.makeArmorMap(4, 6, 9, 4);
    }

    public static void register(IEventBus eventBus) {
        ARMOR_MATERIALS.register(eventBus);
    }
}

