/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Armor;

import com.google.common.base.Suppliers;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.NotNull;

public class HnSArmorItem
extends ArmorItem {
    private final Supplier<ItemAttributeModifiers> defaultModifiers = Suppliers.memoize(() -> {
        int i = ((ArmorMaterial)material.value()).getDefense(type);
        float f = ((ArmorMaterial)material.value()).toughness();
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        builder.add(Attributes.ARMOR, new AttributeModifier(resourceLocation, (double)i, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourceLocation, (double)f, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        float resistance = ((ArmorMaterial)material.value()).knockbackResistance();
        if (resistance > 0.0f) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourceLocation, (double)resistance, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        }
        for (AttributeContainer holder : attributeContainers) {
            builder.add(holder.attribute(), holder.createModifier(type.getSlot().getName()), equipmentSlotGroup);
        }
        return builder.build();
    });

    public HnSArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, AttributeContainer ... attributeContainers) {
        super(material, type, properties);
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers modifiers = super.getDefaultAttributeModifiers(stack);
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        List entries = modifiers.modifiers();
        for (ItemAttributeModifiers.Entry entry : entries) {
            builder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        List<ItemAttributeModifiers.Entry> extraEntries = this.createExtraAttributes();
        for (ItemAttributeModifiers.Entry entry : extraEntries) {
            builder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        return builder.build();
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.defaultModifiers.get();
    }

    public List<ItemAttributeModifiers.Entry> createExtraAttributes() {
        return List.of();
    }
}

