/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Item.Armor.AzureLib.Blazeborne;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.item.armor.IDisableHat;
import io.redspace.ironsspellbooks.item.armor.IDisableJacket;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import java.util.List;
import net.hazen.hazennstuff.Compat.MalumCompat;
import net.hazen.hazennstuff.Dispatcher.HnSDispatcher;
import net.hazen.hazennstuff.Item.Armor.HnSArmorMaterials;
import net.hazen.hazennstuff.Item.Armor.ImbuableHnSArmorItem;
import net.hazen.hazennstuff.Registries.HnSEffects;
import net.hazen.hazennstuff.Registries.HnSItems;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;

public class BlazeborneArmorItem
extends ImbuableHnSArmorItem
implements IDisableJacket,
IDisableHat {
    public final HnSDispatcher dispatcher = new HnSDispatcher();

    public BlazeborneArmorItem(ArmorItem.Type type, Item.Properties settings) {
        super((Holder<ArmorMaterial>)HnSArmorMaterials.PURE_ARMOR_TIER_MATERIAL, type, settings, new AttributeContainer((Holder)AttributeRegistry.MAX_MANA, 150.0, AttributeModifier.Operation.ADD_VALUE), new AttributeContainer((Holder)AttributeRegistry.HOLY_SPELL_POWER, 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeContainer((Holder)AttributeRegistry.ELDRITCH_SPELL_POWER, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeContainer((Holder)AttributeRegistry.SPELL_POWER, 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
    }

    @Override
    public List<ItemAttributeModifiers.Entry> createExtraAttributes() {
        EquipmentSlotGroup group = EquipmentSlotGroup.bySlot((EquipmentSlot)this.getEquipmentSlot());
        ItemAttributeModifiers.Builder attributes = ItemAttributeModifiers.builder();
        MalumCompat.addArcaneResonance(attributes, group);
        return attributes.build().modifiers();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        if (entity instanceof Player) {
            player = (Player)entity;
            if (!level.isClientSide() && this.isWearingFullSet(player)) {
                this.evaluateArmorEffects(player);
            }
        }
        if (!level.isClientSide && entity instanceof Player) {
            player = (Player)entity;
            player.getArmorSlots().forEach(wornArmor -> {
                if (wornArmor != null && wornArmor.is(HnSItems.BLAZEBORNE_HELMET)) {
                    this.dispatcher.idle((Entity)player, (ItemStack)wornArmor);
                }
                if (wornArmor != null && wornArmor.is(HnSItems.BLAZEBORNE_CHESTPLATE)) {
                    this.dispatcher.idle((Entity)player, (ItemStack)wornArmor);
                }
                if (wornArmor != null && wornArmor.is(HnSItems.BLAZEBORNE_LEGGINGS)) {
                    this.dispatcher.idle((Entity)player, (ItemStack)wornArmor);
                }
                if (wornArmor != null && wornArmor.is(HnSItems.BLAZEBORNE_BOOTS)) {
                    this.dispatcher.idle((Entity)player, (ItemStack)wornArmor);
                }
            });
        }
    }

    private void evaluateArmorEffects(Player player) {
        if (!player.hasEffect(HnSEffects.MAGE_SET_BONUS)) {
            player.addEffect(new MobEffectInstance(HnSEffects.MAGE_SET_BONUS, 320, 0, false, false, false));
        }
    }

    private boolean isWearingFullSet(Player player) {
        return player.getItemBySlot(ArmorItem.Type.HELMET.getSlot()).getItem() instanceof BlazeborneArmorItem && player.getItemBySlot(ArmorItem.Type.CHESTPLATE.getSlot()).getItem() instanceof BlazeborneArmorItem && player.getItemBySlot(ArmorItem.Type.LEGGINGS.getSlot()).getItem() instanceof BlazeborneArmorItem && player.getItemBySlot(ArmorItem.Type.BOOTS.getSlot()).getItem() instanceof BlazeborneArmorItem;
    }
}

