/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Entity.Spells.Nature.SpiderLily;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.events.CounterSpellEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.entity.spells.poison_cloud.PoisonCloud;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.Optional;
import net.hazen.hazennstuff.Registries.HnSEntityRegistry;
import net.hazen.hazennstuff.Registries.HnSParticleHelper;
import net.hazen.hazennstuff.Spells.HnSSpellRegistries;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SpiderLily
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected boolean hasEmittedPoison = false;
    private final RawAnimation idle = RawAnimation.begin().thenLoop("animation.spider_lily.idle");

    public SpiderLily(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setNoGravity(true);
    }

    public SpiderLily(Level level, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)HnSEntityRegistry.SPIDER_LILY.get()), level);
        this.setOwner((Entity)shooter);
    }

    public void trailParticles() {
        Vec3 pos = this.getBoundingBox().getCenter().add(this.getDeltaMovement());
        Vec3 random = Utils.getRandomVec3((double)0.0);
        pos = pos.add(this.getDeltaMovement());
        this.level().addParticle(HnSParticleHelper.LEAF_PARTICLE, pos.x, pos.y, pos.z, random.x, random.y, random.z);
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)HnSParticleHelper.LEAF_PARTICLE, (double)x, (double)y, (double)z, (int)12, (double)0.08, (double)0.08, (double)0.08, (double)0.3, (boolean)false);
    }

    public float getSpeed() {
        return 1.2f;
    }

    public Optional<Holder<SoundEvent>> getImpactSound() {
        return Optional.of(SoundRegistry.ACID_ORB_IMPACT);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (this.level().isClientSide) {
            return;
        }
        Entity target = entityHitResult.getEntity();
        LivingEntity owner = (LivingEntity)this.getOwner();
        CounterSpellEvent event = new CounterSpellEvent((Entity)owner, target);
        NeoForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled() && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            MagicData targetMagicData = MagicData.getPlayerMagicData((LivingEntity)livingTarget);
            if (target instanceof AntiMagicSusceptible) {
                AntiMagicSusceptible antiMagicTarget = (AntiMagicSusceptible)target;
                if (antiMagicTarget instanceof IMagicSummon) {
                    IMagicSummon summon = (IMagicSummon)antiMagicTarget;
                    if (summon.getSummoner() == owner) {
                        Mob mob;
                        if (summon instanceof Mob && (mob = (Mob)summon).getTarget() == null) {
                            antiMagicTarget.onAntiMagic(targetMagicData);
                        }
                    } else {
                        antiMagicTarget.onAntiMagic(targetMagicData);
                    }
                } else {
                    antiMagicTarget.onAntiMagic(targetMagicData);
                }
            } else if (target instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)target;
                Utils.serverSideCancelCast((ServerPlayer)serverPlayer, (boolean)true);
                MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerRecasts().removeAll(RecastResult.COUNTERSPELL);
            } else if (target instanceof IMagicEntity) {
                IMagicEntity magicEntity = (IMagicEntity)target;
                magicEntity.cancelCast();
            }
            for (Holder mobEffect : livingTarget.getActiveEffectsMap().keySet().stream().toList()) {
                if (!(mobEffect.value() instanceof MagicMobEffect)) continue;
                livingTarget.removeEffect(mobEffect);
            }
            try {
                DamageSources.applyDamage((Entity)target, (float)this.getDamage(), (DamageSource)HnSSpellRegistries.COUNTERSPELL_SPIDER_LILY.get().getDamageSource((Entity)this, (Entity)owner));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (target.getType() != EntityType.ENDERMAN && !this.hasEmittedPoison) {
                this.createPoisonCloud(target.position());
            }
        }
        this.discard();
    }

    public void createPoisonCloud(Vec3 location) {
        if (!this.level().isClientSide && !this.hasEmittedPoison) {
            PoisonCloud cloud = new PoisonCloud(this.level());
            cloud.setOwner(this.getOwner());
            cloud.setDuration(200);
            cloud.setDamage(this.getDamage());
            cloud.moveTo(location);
            this.level().addFreshEntity((Entity)cloud);
            this.hasEmittedPoison = true;
        }
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide && !this.hasEmittedPoison) {
            this.createPoisonCloud(blockHitResult.getLocation());
        }
        this.discard();
    }

    private PlayState predicate(AnimationState event) {
        event.getController().setAnimation(this.idle);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

