/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Entity.Spells.Lightning.InstantLightningStrike;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.ISSDamageTypes;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import io.redspace.ironsspellbooks.particle.ZapParticleOption;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LightningStrike
extends AoeEntity {
    private DamageSource damageSource;
    private int waitTime = 0;

    public LightningStrike(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setRadius(3.0f);
        this.setCircular();
    }

    public LightningStrike(Level level) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.LIGHTNING_STRIKE.get()), level);
    }

    public void tick() {
        if (!this.level().isClientSide) {
            if (this.tickCount < this.waitTime) {
                return;
            }
            if (this.tickCount == this.waitTime + 1) {
                this.checkHits();
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleHelper.ELECTRIC_SPARKS, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (int)25, (double)0.2f, (double)0.2f, (double)0.2f, (double)0.25, (boolean)true);
                Vec3 bottom = this.position();
                Vec3 top = bottom.add(0.0, 15.0, 0.0);
                Vec3 middle = bottom.add(Utils.getRandomScaled((double)2.0), (double)Utils.random.nextIntBetweenInclusive(3, 12), Utils.getRandomScaled((double)2.0));
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new ZapParticleOption(top), (double)middle.x, (double)middle.y, (double)middle.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new ZapParticleOption(middle), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                if (Utils.random.nextFloat() < 0.3f) {
                    Vec3 split = middle.add(Utils.getRandomScaled((double)2.0), -Math.abs(Utils.getRandomScaled((double)2.0)), Utils.getRandomScaled((double)2.0));
                    MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new ZapParticleOption(middle), (double)split.x, (double)split.y, (double)split.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                }
                this.playSound((SoundEvent)SoundRegistry.SMALL_LIGHTNING_STRIKE.get(), 2.0f, 0.8f + this.random.nextFloat() * 0.5f);
            }
            if (this.tickCount > this.waitTime + 5) {
                this.discard();
            }
        }
    }

    public void applyEffect(LivingEntity target) {
        if (target == this.getOwner()) {
            return;
        }
        if (this.damageSource == null) {
            this.damageSource = new DamageSource(DamageSources.getHolderFromResource((Entity)target, (ResourceKey)ISSDamageTypes.LIGHTNING_MAGIC), (Entity)this, this.getOwner());
        }
        DamageSources.ignoreNextKnockback((LivingEntity)target);
        target.hurt(this.damageSource, this.getDamage());
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public float getParticleCount() {
        return 0.0f;
    }

    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }
}

