/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Entity.Spells.Fire.ImmolatingObliterator;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.events.CounterSpellEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Optional;
import net.hazen.hazennstuff.Registries.HnSEntityRegistry;
import net.hazen.hazennstuff.Spells.HnSSpellRegistries;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ScorchingSlash
extends AbstractMagicProjectile
implements GeoEntity {
    public final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int despawnTimer = 20;
    private final RawAnimation idle = RawAnimation.begin().thenLoop("animation.spectral_axe.idle");
    private float damage = 2.0f;

    public void tick() {
        super.tick();
        if (this.despawnTimer > 0) {
            --this.despawnTimer;
            if (this.despawnTimer == 0) {
                this.discard();
            }
        }
    }

    public void startDespawning() {
        this.despawnTimer = 15;
    }

    public boolean isDespawning() {
        return this.despawnTimer > 0;
    }

    public float getDespawnPercent(float partialTicks) {
        return ((float)this.despawnTimer - partialTicks) / 10.0f;
    }

    public ScorchingSlash(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setNoGravity(true);
    }

    public ScorchingSlash(Level level, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)HnSEntityRegistry.SCORCHING_SLASH.get()), level);
        this.setOwner((Entity)shooter);
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleHelper.FIERY_SMOKE, (double)x, (double)y, (double)z, (int)12, (double)0.08, (double)0.08, (double)0.08, (double)0.3, (boolean)false);
    }

    public void trailParticles() {
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() - vec3.x;
        double d1 = this.getY() - vec3.y;
        double d2 = this.getZ() - vec3.z;
        int count = Mth.clamp((int)((int)(vec3.lengthSqr() * 2.0)), (int)1, (int)4);
        for (int i = 0; i < count; ++i) {
            Vec3 random = Utils.getRandomVec3((double)(this.getBbHeight() * 0.2f));
            float f = (float)i / (float)count;
            double x = Mth.lerp((double)f, (double)d0, (double)(this.getX() + vec3.x));
            double y = Mth.lerp((double)f, (double)d1, (double)(this.getY() + vec3.y));
            double z = Mth.lerp((double)f, (double)d2, (double)(this.getZ() + vec3.z));
            this.level().addParticle(ParticleHelper.FIERY_SMOKE, true, x - random.x, y + (double)(this.getBbHeight() * 0.5f) - random.y, z - random.z, 0.0, 0.0, 0.0);
        }
    }

    public float getSpeed() {
        return 1.6f;
    }

    public Optional<Holder<SoundEvent>> getImpactSound() {
        return Optional.of(SoundRegistry.FIERY_EXPLOSION);
    }

    protected void doImpactSound(Holder<SoundEvent> sound) {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), sound, SoundSource.NEUTRAL, 1.5f, 1.0f);
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        this.discard();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Entity target = entityHitResult.getEntity();
        LivingEntity owner = (LivingEntity)this.getOwner();
        CounterSpellEvent event = new CounterSpellEvent((Entity)owner, target);
        NeoForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled() && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            MagicData targetMagicData = MagicData.getPlayerMagicData((LivingEntity)livingTarget);
            if (target instanceof AntiMagicSusceptible) {
                AntiMagicSusceptible antiMagicTarget = (AntiMagicSusceptible)target;
                if (antiMagicTarget instanceof IMagicSummon) {
                    IMagicSummon summon = (IMagicSummon)antiMagicTarget;
                    if (summon.getSummoner() == owner) {
                        Mob mob;
                        if (summon instanceof Mob && (mob = (Mob)summon).getTarget() == null) {
                            antiMagicTarget.onAntiMagic(targetMagicData);
                        }
                    } else {
                        antiMagicTarget.onAntiMagic(targetMagicData);
                    }
                } else {
                    antiMagicTarget.onAntiMagic(targetMagicData);
                }
            } else if (target instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)target;
                Utils.serverSideCancelCast((ServerPlayer)serverPlayer, (boolean)true);
                MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerRecasts().removeAll(RecastResult.COUNTERSPELL);
            } else if (target instanceof IMagicEntity) {
                IMagicEntity magicEntity = (IMagicEntity)target;
                magicEntity.cancelCast();
            }
            for (Holder mobEffect : livingTarget.getActiveEffectsMap().keySet().stream().toList()) {
                if (!(mobEffect.value() instanceof MagicMobEffect)) continue;
                livingTarget.removeEffect(mobEffect);
            }
            DamageSources.applyDamage((Entity)target, (float)this.damage, (DamageSource)HnSSpellRegistries.SCORCHING_SLASH.get().getDamageSource((Entity)this, (Entity)owner));
        }
    }

    private PlayState predicate(AnimationState event) {
        event.getController().setAnimation(this.idle);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }
}

