/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Entity.Spells.Eldritch.SoulSeeker;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.events.CounterSpellEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.particle.ZapParticleOption;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import mod.azure.azurelib.core.utils.MathHelper;
import net.hazen.hazennstuff.Registries.HnSEntityRegistry;
import net.hazen.hazennstuff.Registries.HnSSounds;
import net.hazen.hazennstuff.Spells.HnSSpellRegistries;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SoulSeeker
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private LivingEntity lockedTarget = null;
    private final RawAnimation idle = RawAnimation.begin().thenLoop("animation.spark.idle");
    private float damage = 2.0f;

    public SoulSeeker(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setNoGravity(true);
    }

    public SoulSeeker(Level level, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)HnSEntityRegistry.SOUL_SEEKER.get()), level);
        this.setOwner((Entity)shooter);
    }

    public void travel() {
        this.setPos(this.position().add(this.getDeltaMovement()));
        if (!this.isNoGravity()) {
            Vec3 vec3 = this.getDeltaMovement();
            this.setDeltaMovement(vec3.x, vec3.y - (double)0.05f, vec3.z);
        }
    }

    public void setRotation(float x, float y) {
        this.setXRot(x);
        this.xRotO = x;
        this.setYRot(y);
        this.yRotO = y;
    }

    public void trailParticles() {
        Vec3 pos = this.getBoundingBox().getCenter().add(this.getDeltaMovement());
        Vec3 random = Utils.getRandomVec3((double)0.25).add(pos);
        pos = pos.add(this.getDeltaMovement());
        this.level().addParticle((ParticleOptions)new ZapParticleOption(random), pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleHelper.ELECTRIC_SPARKS, (double)x, (double)y, (double)z, (int)12, (double)0.08, (double)0.08, (double)0.08, (double)0.3, (boolean)false);
    }

    public float getSpeed() {
        return 1.4f;
    }

    public Optional<Holder<SoundEvent>> getImpactSound() {
        return Optional.of(HnSSounds.BRIMSTONE_HELLBLAST_IMPACT);
    }

    protected void doImpactSound(Holder<SoundEvent> sound) {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), sound, SoundSource.NEUTRAL, 1.5f, 1.0f);
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        this.discard();
    }

    private LivingEntity findNearestTarget() {
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(12.0), e -> e != this.getOwner() && e.isAlive() && !e.isInvisible());
        return entities.stream().min(Comparator.comparingDouble(e -> e.distanceToSqr((Entity)this))).orElse(null);
    }

    private float getYawFromVec(Vec3 vec) {
        return (float)(Math.toDegrees(Math.atan2(vec.z, vec.x)) - 180.0);
    }

    private float getPitchFromVec(Vec3 vec) {
        return (float)(-Math.toDegrees(Math.atan2(vec.y, vec.horizontalDistance())));
    }

    private float rotLerp(float lerpSpeed, float current, float target) {
        float delta = MathHelper.wrapDegrees((float)(target - current));
        return current + delta * Math.min(lerpSpeed * 0.05f, 1.0f);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.tickCount > 10) {
            if (this.lockedTarget == null || !this.lockedTarget.isAlive()) {
                this.lockedTarget = this.findNearestTarget();
            }
            if (this.lockedTarget != null) {
                Vec3 toTarget = this.lockedTarget.getEyePosition().subtract(this.position());
                Vec3 currentMotion = this.getDeltaMovement();
                double homingStrength = 0.05;
                double speed = currentMotion.length();
                Vec3 desiredDirection = toTarget.normalize();
                Vec3 newDirection = currentMotion.normalize().scale(1.0 - homingStrength).add(desiredDirection.scale(homingStrength)).normalize();
                Vec3 newMotion = newDirection.scale(speed);
                this.setDeltaMovement(newMotion);
            }
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Entity target = entityHitResult.getEntity();
        LivingEntity owner = (LivingEntity)this.getOwner();
        CounterSpellEvent event = new CounterSpellEvent((Entity)owner, target);
        NeoForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled() && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            MagicData targetMagicData = MagicData.getPlayerMagicData((LivingEntity)livingTarget);
            if (target instanceof AntiMagicSusceptible) {
                AntiMagicSusceptible antiMagicTarget = (AntiMagicSusceptible)target;
                if (antiMagicTarget instanceof IMagicSummon) {
                    IMagicSummon summon = (IMagicSummon)antiMagicTarget;
                    if (summon.getSummoner() == owner) {
                        Mob mob;
                        if (summon instanceof Mob && (mob = (Mob)summon).getTarget() == null) {
                            antiMagicTarget.onAntiMagic(targetMagicData);
                        }
                    } else {
                        antiMagicTarget.onAntiMagic(targetMagicData);
                    }
                } else {
                    antiMagicTarget.onAntiMagic(targetMagicData);
                }
            } else if (target instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)target;
                Utils.serverSideCancelCast((ServerPlayer)serverPlayer, (boolean)true);
                MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerRecasts().removeAll(RecastResult.COUNTERSPELL);
            } else if (target instanceof IMagicEntity) {
                IMagicEntity magicEntity = (IMagicEntity)target;
                magicEntity.cancelCast();
            }
            for (Holder mobEffect : livingTarget.getActiveEffectsMap().keySet().stream().toList()) {
                if (!(mobEffect.value() instanceof MagicMobEffect)) continue;
                livingTarget.removeEffect(mobEffect);
            }
            try {
                DamageSources.applyDamage((Entity)target, (float)this.damage, (DamageSource)HnSSpellRegistries.SOUL_SEEKERS.get().getDamageSource((Entity)this, (Entity)owner));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.discard();
    }

    private PlayState predicate(AnimationState event) {
        event.getController().setAnimation(this.idle);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }
}

