/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Entity.Mobs.Summons.SummonTerraprisma;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.mobs.goals.WarlockAttackGoal;
import io.redspace.ironsspellbooks.network.SyncAnimationPacket;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import net.hazen.hazennstuff.Entity.Mobs.Summons.SummonTerraprisma.SummonedTerraprisma;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class TerraprismaAttackGoal
extends WarlockAttackGoal {
    final SummonedTerraprisma keeper;
    int meleeAnimTimer = -1;
    public SummonedTerraprisma.AttackType currentAttack;
    public SummonedTerraprisma.AttackType nextAttack;
    public SummonedTerraprisma.AttackType queueCombo;
    private boolean hasDashed;
    private boolean hasHitDash;
    private Vec3 oldDashPos;

    public TerraprismaAttackGoal(SummonedTerraprisma abstractSpellCastingMob, double pSpeedModifier, int minAttackInterval, int maxAttackInterval) {
        super((IMagicEntity)abstractSpellCastingMob, pSpeedModifier, minAttackInterval, maxAttackInterval);
        this.keeper = abstractSpellCastingMob;
        this.nextAttack = this.randomizeNextAttack(0.0f);
        this.wantsToMelee = true;
    }

    protected float meleeBias() {
        return 1.0f;
    }

    public boolean isActing() {
        return super.isActing() || this.meleeAnimTimer > 0;
    }

    protected void handleAttackLogic(double distanceSquared) {
        float meleeRange = this.meleeRange();
        float distance = Mth.sqrt((float)((float)distanceSquared));
        this.mob.getLookControl().setLookAt((Entity)this.target);
        if (this.meleeAnimTimer > 0) {
            this.forceFaceTarget();
            --this.meleeAnimTimer;
            if (this.currentAttack.data.isHitFrame(this.meleeAnimTimer - 4)) {
                if (this.currentAttack != SummonedTerraprisma.AttackType.Dash) {
                    this.playSwingSound();
                }
            } else if (this.currentAttack.data.isHitFrame(this.meleeAnimTimer)) {
                if (this.currentAttack != SummonedTerraprisma.AttackType.Dash) {
                    Vec3 lunge = this.target.position().subtract(this.mob.position()).normalize().scale((double)0.55f);
                    this.mob.push(lunge.x, lunge.y, lunge.z);
                    if (distance <= meleeRange && Utils.hasLineOfSight((Level)this.mob.level(), (Entity)this.mob, (Entity)this.target, (boolean)true)) {
                        boolean flag = this.mob.doHurtTarget((Entity)this.target);
                        this.target.invulnerableTime = 0;
                        if (flag) {
                            this.playImpactSound();
                            if (this.currentAttack.data.isSingleHit() && (this.mob.getRandom().nextFloat() < 0.75f || this.target.isBlocking())) {
                                this.queueCombo = this.randomizeNextAttack(0.0f);
                            }
                        }
                    }
                } else {
                    if (!this.hasDashed) {
                        Vec3 dash = this.target.position().subtract(this.mob.position()).normalize().multiply(2.4, 0.5, 2.4).add(0.0, 0.15, 0.0);
                        this.mob.push(dash.x, dash.y, dash.z);
                        this.oldDashPos = this.mob.position();
                        this.mob.getNavigation().stop();
                        this.hasDashed = true;
                        this.playSwingSound();
                    }
                    if (!this.hasHitDash && distance <= meleeRange * 0.45f) {
                        if (this.mob.doHurtTarget((Entity)this.target)) {
                            this.playImpactSound();
                        }
                        Vec3 knockback = this.oldDashPos.subtract(this.target.position());
                        this.target.knockback(1.0, knockback.x, knockback.z);
                        this.hasHitDash = true;
                    }
                }
            }
        } else if (this.queueCombo != null && this.target != null && !this.target.isDeadOrDying()) {
            this.nextAttack = this.queueCombo;
            this.queueCombo = null;
            this.doMeleeAction();
        } else if (this.meleeAnimTimer == 0) {
            this.nextAttack = this.randomizeNextAttack(distance);
            this.resetMeleeAttackInterval(distanceSquared);
            this.meleeAnimTimer = -1;
        } else {
            int n = this.nextAttack == SummonedTerraprisma.AttackType.Dash ? 3 : 1;
            if (distance < meleeRange * (float)n) {
                if (this.hasLineOfSight && --this.meleeAttackDelay == 0) {
                    this.doMeleeAction();
                } else if (this.meleeAttackDelay < 0) {
                    this.resetMeleeAttackInterval(distanceSquared);
                }
            } else if (--this.meleeAttackDelay < 0) {
                this.resetMeleeAttackInterval(distanceSquared);
                this.nextAttack = this.randomizeNextAttack(distance);
            }
        }
    }

    private SummonedTerraprisma.AttackType randomizeNextAttack(float distance) {
        int i;
        float meleeRange = this.meleeRange();
        if (distance < meleeRange * 1.5f) {
            i = SummonedTerraprisma.AttackType.values().length - 1;
        } else {
            if (this.mob.getRandom().nextFloat() < 0.25f && distance > meleeRange * 2.5f) {
                return SummonedTerraprisma.AttackType.Dash;
            }
            i = SummonedTerraprisma.AttackType.values().length;
        }
        return SummonedTerraprisma.AttackType.values()[this.mob.getRandom().nextInt(i)];
    }

    private void forceFaceTarget() {
        if (!this.hasDashed) {
            double d0 = this.target.getX() - this.mob.getX();
            double d1 = this.target.getZ() - this.mob.getZ();
            float yRot = (float)(Mth.atan2((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
            this.mob.setYBodyRot(yRot);
            this.mob.setYHeadRot(yRot);
            this.mob.setYRot(yRot);
        }
    }

    protected void doMeleeAction() {
        this.currentAttack = this.nextAttack;
        if (this.currentAttack != null) {
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.meleeAnimTimer = this.currentAttack.data.lengthInTicks;
            this.hasDashed = false;
            this.hasHitDash = false;
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this.keeper, (CustomPacketPayload)new SyncAnimationPacket(this.currentAttack.toString(), (Entity)this.keeper), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void doMovement(double distanceSquared) {
        float meleeRange = this.meleeRange();
        if (this.target.isDeadOrDying()) {
            this.mob.getNavigation().stop();
        } else if (distanceSquared > (double)(meleeRange * meleeRange)) {
            this.mob.getNavigation().moveTo((Entity)this.target, this.speedModifier * (double)1.3f);
        }
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() || this.meleeAnimTimer > 0;
    }

    public void stop() {
        super.stop();
        this.meleeAnimTimer = -1;
        this.queueCombo = null;
    }

    public void playSwingSound() {
        this.mob.playSound((SoundEvent)SoundRegistry.KEEPER_SWING.get(), 1.0f, (float)Mth.randomBetweenInclusive((RandomSource)this.mob.getRandom(), (int)9, (int)13) * 0.1f);
    }

    public void playImpactSound() {
        this.mob.playSound((SoundEvent)SoundRegistry.KEEPER_SWORD_IMPACT.get(), 1.0f, (float)Mth.randomBetweenInclusive((RandomSource)this.mob.getRandom(), (int)9, (int)13) * 0.1f);
    }
}

