/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Datagen.Worldgen;

import java.util.List;
import net.hazen.hazennstuff.Block.HnSBlocks;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class HnSConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ZENALITE_ORE_KEY = HnSConfiguredFeatures.registerKey("zenalite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RUNESTONE_SLAG_KEY = HnSConfiguredFeatures.registerKey("runestone_slag");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SOLAR_CORE_ORE_KEY = HnSConfiguredFeatures.registerKey("solar_core_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHLOROPHYTE_ORE_KEY = HnSConfiguredFeatures.registerKey("chlorophyte_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DREADSTONE_ORE_KEY = HnSConfiguredFeatures.registerKey("dreadstone_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WISEWOOD_KEY = HnSConfiguredFeatures.registerKey("wisewood");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROSTBITE_BIRCH_KEY = HnSConfiguredFeatures.registerKey("frostbite_birch");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        BlockMatchTest netherrackReplaceables = new BlockMatchTest(Blocks.NETHERRACK);
        BlockMatchTest blackstoneReplaceables = new BlockMatchTest(Blocks.BLACKSTONE);
        BlockMatchTest endReplaceables = new BlockMatchTest(Blocks.END_STONE);
        BlockMatchTest mudReplaceables = new BlockMatchTest(Blocks.MUD);
        List<OreConfiguration.TargetBlockState> netherSolarCoreOres = List.of(OreConfiguration.target((RuleTest)netherrackReplaceables, (BlockState)((Block)HnSBlocks.SOLAR_CORE_NETHERACK_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)blackstoneReplaceables, (BlockState)((Block)HnSBlocks.SOLAR_CORE_BLACKSTONE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldRunestoneSlag = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)HnSBlocks.RUNESTONE_SLAG.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)HnSBlocks.RUNESTONE_SLAG.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> endZenaliteOres = List.of(OreConfiguration.target((RuleTest)endReplaceables, (BlockState)((Block)HnSBlocks.ZENALITE_END_STONE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldChlorophyteOres = List.of(OreConfiguration.target((RuleTest)mudReplaceables, (BlockState)((Block)HnSBlocks.CHLOROPHYTE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)HnSBlocks.CHLOROPHYTE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldDreadstoneOres = List.of(OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)HnSBlocks.DREADSTONE_ORE.get()).defaultBlockState()));
        HnSConfiguredFeatures.register(context, SOLAR_CORE_ORE_KEY, Feature.ORE, new OreConfiguration(netherSolarCoreOres, 6));
        HnSConfiguredFeatures.register(context, RUNESTONE_SLAG_KEY, Feature.ORE, new OreConfiguration(overworldRunestoneSlag, 16));
        HnSConfiguredFeatures.register(context, ZENALITE_ORE_KEY, Feature.ORE, new OreConfiguration(endZenaliteOres, 6));
        HnSConfiguredFeatures.register(context, CHLOROPHYTE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldChlorophyteOres, 6));
        HnSConfiguredFeatures.register(context, DREADSTONE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldDreadstoneOres, 6));
        HnSConfiguredFeatures.register(context, WISEWOOD_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)HnSBlocks.WISEWOOD_LOG.get())), (TrunkPlacer)new ForkingTrunkPlacer(2, 1, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)HnSBlocks.WISEWOOD_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)3), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build());
        HnSConfiguredFeatures.register(context, FROSTBITE_BIRCH_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)HnSBlocks.FROSTBITE_BIRCH_LOG.get())), (TrunkPlacer)new ForkingTrunkPlacer(2, 1, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)HnSBlocks.PERMAFROST_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)3), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build());
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hazennstuff", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

