/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.Datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.hazen.hazennstuff.Datagen.HnSDatapackProvider;
import net.hazen.hazennstuff.Datagen.HnSRecipeProvider;
import net.hazen.hazennstuff.Datagen.ItemGenerator.HnSBlockStateProvider;
import net.hazen.hazennstuff.Datagen.ItemGenerator.HnSBlockTagProvider;
import net.hazen.hazennstuff.Datagen.ItemGenerator.HnSItemModelProvider;
import net.hazen.hazennstuff.Datagen.ItemGenerator.HnSItemTagProvider;
import net.hazen.hazennstuff.Datagen.LootTables.HnSBlockLootTableProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class HnSDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(HnSBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new HnSRecipeProvider(packOutput, lookupProvider));
        HnSBlockTagProvider blockTagsProvider = new HnSBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new HnSItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new HnSItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new HnSBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new HnSDatapackProvider(packOutput, lookupProvider));
    }
}

