/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.item.armor;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import java.util.function.Consumer;
import mod.azure.azurelib.common.api.common.animatable.GeoItem;
import mod.azure.azurelib.common.internal.client.RenderProvider;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import net.hazen.hazennstuff.effect.HnSEffects;
import net.hazen.hazennstuff.entity.render.armor.CryogenicRulerArmorRenderer;
import net.hazen.hazennstuff.item.armor.HnSArmorMaterials;
import net.hazen.hazennstuff.item.armor.ImbuableHnSArmorItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CryogenicRulerArmorItem
extends ImbuableHnSArmorItem
implements GeoAnimatable,
GeoItem {
    public CryogenicRulerArmorItem(ArmorItem.Type type, Item.Properties settings) {
        super((Holder<ArmorMaterial>)HnSArmorMaterials.CRYOGENIC_RULER_MATERIAL, type, settings, new AttributeContainer((Holder)AttributeRegistry.MAX_MANA, 150.0, AttributeModifier.Operation.ADD_VALUE), new AttributeContainer((Holder)AttributeRegistry.ICE_SPELL_POWER, 0.15, AttributeModifier.Operation.ADD_VALUE), new AttributeContainer((Holder)AttributeRegistry.ELDRITCH_SPELL_POWER, 0.05, AttributeModifier.Operation.ADD_VALUE), new AttributeContainer((Holder)AttributeRegistry.SPELL_POWER, 0.15, AttributeModifier.Operation.ADD_VALUE));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide() && this.isWearingFullSet(player)) {
                this.evaluateArmorEffects(player);
            }
        }
    }

    private void evaluateArmorEffects(Player player) {
        if (!player.hasEffect(HnSEffects.SUB_ZERO_EFFECT)) {
            player.addEffect(new MobEffectInstance(HnSEffects.SUB_ZERO_EFFECT, 200, 0, false, false, false));
        }
    }

    private boolean isWearingFullSet(Player player) {
        return player.getItemBySlot(ArmorItem.Type.HELMET.getSlot()).getItem() instanceof CryogenicRulerArmorItem && player.getItemBySlot(ArmorItem.Type.CHESTPLATE.getSlot()).getItem() instanceof CryogenicRulerArmorItem && player.getItemBySlot(ArmorItem.Type.LEGGINGS.getSlot()).getItem() instanceof CryogenicRulerArmorItem && player.getItemBySlot(ArmorItem.Type.BOOTS.getSlot()).getItem() instanceof CryogenicRulerArmorItem;
    }

    @Override
    public void createRenderer(Consumer<RenderProvider> consumer) {
        consumer.accept(new RenderProvider(this){
            private CryogenicRulerArmorRenderer renderer;

            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<LivingEntity> original) {
                if (this.renderer == null) {
                    this.renderer = new CryogenicRulerArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }
}

