/*
 * Decompiled with CFR 0.152.
 */
package net.hazen.hazennstuff.block;

import java.util.function.Supplier;
import net.hazen.hazennstuff.block.custom.ModFlammableRotatedPillarBlock;
import net.hazen.hazennstuff.item.item.HnSItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RootsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class HnSBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"hazennstuff");
    public static final DeferredBlock<Block> RUNESTONE_SLAG = HnSBlocks.registerBlock("runestone_slag", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.ANCIENT_DEBRIS)));
    public static final DeferredBlock<Block> AQUASTONE = HnSBlocks.registerBlock("aquastone", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.ANCIENT_DEBRIS)));
    public static final DeferredBlock<Block> FIREBLOSSOM = HnSBlocks.registerBlock("fireblossom", () -> new RootsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).replaceable().noCollission().instabreak().sound(SoundType.FLOWERING_AZALEA).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> ABYSSLATE = HnSBlocks.registerBlock("abysslate", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.ANCIENT_DEBRIS)));
    public static final DeferredBlock<Block> PHANTASMIUM = HnSBlocks.registerBlock("phantasmium", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.ANCIENT_DEBRIS)));
    public static final DeferredBlock<Block> VOIDSTONE = HnSBlocks.registerBlock("voidstone", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.ANCIENT_DEBRIS)));
    public static final DeferredBlock<Block> COBBLED_VOIDSTONE = HnSBlocks.registerBlock("cobbled_voidstone", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.ANCIENT_DEBRIS)));
    public static final DeferredBlock<Block> ZENALITE_BRICKS = HnSBlocks.registerBlock("zenalite_bricks", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE_TILES)));
    public static final DeferredBlock<StairBlock> ZENALITE_STAIRS = HnSBlocks.registerBlock("zenalite_stairs", () -> new StairBlock(((Block)ZENALITE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.of().strength(2.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE_TILES)));
    public static final DeferredBlock<SlabBlock> ZENALITE_SLAB = HnSBlocks.registerBlock("zenalite_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().strength(2.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE_TILES)));
    public static final DeferredBlock<Block> ZENALITE_STONE_ORE = HnSBlocks.registerBlock("zenalite_stone_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().strength(3.0f).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> ZENALITE_DEEPSLATE_ORE = HnSBlocks.registerBlock("zenalite_deepslate_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().strength(3.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE)));
    public static final DeferredBlock<Block> ZENALITE_ABYSSLATE_ORE = HnSBlocks.registerBlock("zenalite_abysslate_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().strength(3.0f).requiresCorrectToolForDrops().sound(SoundType.ANCIENT_DEBRIS)));
    public static final DeferredBlock<Block> ZENALITE_VOIDSTONE_ORE = HnSBlocks.registerBlock("zenalite_voidstone_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().strength(3.0f).requiresCorrectToolForDrops().sound(SoundType.ANCIENT_DEBRIS)));
    public static final DeferredBlock<Block> WISEWOOD_PLANK = HnSBlocks.registerBlock("wisewood_planks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava()));
    public static final DeferredBlock<StairBlock> WISEWOOD_STAIRS = HnSBlocks.registerBlock("wisewood_stairs", () -> new StairBlock(((Block)WISEWOOD_PLANK.get()).defaultBlockState(), BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava()));
    public static final DeferredBlock<SlabBlock> WISEWOOD_SLAB = HnSBlocks.registerBlock("wisewood_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava()));
    public static final DeferredBlock<Block> WISEWOOD_LOG = HnSBlocks.registerBlock("wisewood_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<Block> WISEWOOD_WOOD = HnSBlocks.registerBlock("wisewood_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    public static final DeferredBlock<Block> STRIPPED_WISEWOOD_LOG = HnSBlocks.registerBlock("stripped_wisewood_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<Block> STRIPPED_WISEWOOD_WOOD = HnSBlocks.registerBlock("stripped_wisewood_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD)));
    public static final DeferredBlock<Block> WISEWOOD_LEAVES = HnSBlocks.registerBlock("wisewood_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }
    });
    public static final DeferredBlock<FenceGateBlock> WISEWOOD_FENCE_GATE = HnSBlocks.registerBlock("wisewood_fence_gate", () -> new FenceGateBlock(WoodType.CHERRY, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava()));
    public static final DeferredBlock<FenceBlock> WISEWOOD_FENCE = HnSBlocks.registerBlock("wisewood_fence", () -> new FenceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.WOOD)));
    public static final DeferredBlock<DoorBlock> WISEWOOD_DOOR = HnSBlocks.registerBlock("wisewood_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<TrapDoorBlock> WISEWOOD_TRAPDOOR = HnSBlocks.registerBlock("wisewood_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava()));
    public static final DeferredBlock<Block> ZENALITE_BLOCK = HnSBlocks.registerBlock("zenalite_block", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK)));
    public static final DeferredBlock<Block> PYRIUM_BLOCK = HnSBlocks.registerBlock("pyrium_block", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK)));
    public static final DeferredBlock<Block> MITHRIL_BLOCK = HnSBlocks.registerBlock("mithril_block", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK)));
    public static final DeferredBlock<Block> ARCANE_STEEL_BLOCK = HnSBlocks.registerBlock("arcane_steel_block", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        HnSBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        HnSItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

