/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.matchhighlight;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.search.MatchesIterator;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.matchhighlight.MatchRegionRetriever;
import guideme.internal.shaded.lucene.search.matchhighlight.OffsetRange;
import guideme.internal.shaded.lucene.search.matchhighlight.OffsetsRetrievalStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class OffsetsFromTokens
implements OffsetsRetrievalStrategy {
    private final String field;
    private final Analyzer analyzer;

    public OffsetsFromTokens(String field, Analyzer analyzer) {
        this.field = field;
        this.analyzer = analyzer;
    }

    @Override
    public List<OffsetRange> get(MatchesIterator matchesIterator, MatchRegionRetriever.FieldValueProvider doc) throws IOException {
        List<String> values = doc.getValues(this.field);
        final HashSet matchTerms = new HashSet();
        while (matchesIterator.next()) {
            Query q = matchesIterator.getQuery();
            q.visit(new QueryVisitor(){

                @Override
                public void consumeTerms(Query query, Term ... terms) {
                    for (Term t : terms) {
                        if (!OffsetsFromTokens.this.field.equals(t.field())) continue;
                        matchTerms.add(t.bytes());
                    }
                }
            });
        }
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        int valueOffset = 0;
        int max = values.size();
        for (int valueIndex = 0; valueIndex < max; ++valueIndex) {
            String value = values.get(valueIndex);
            TokenStream ts = this.analyzer.tokenStream(this.field, value);
            OffsetAttribute offsetAttr = ts.getAttribute(OffsetAttribute.class);
            TermToBytesRefAttribute termAttr = ts.getAttribute(TermToBytesRefAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                if (!matchTerms.contains(termAttr.getBytesRef())) continue;
                int startOffset = valueOffset + offsetAttr.startOffset();
                int endOffset = valueOffset + offsetAttr.endOffset();
                ranges.add(new OffsetRange(startOffset, endOffset));
            }
            ts.end();
            valueOffset += offsetAttr.endOffset() + this.analyzer.getOffsetGap(this.field);
            ts.close();
        }
        return ranges;
    }
}

