/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.TwoPhaseIterator;
import java.io.IOException;

public final class ConstantScoreScorer
extends Scorer {
    private final float score;
    private final ScoreMode scoreMode;
    private final DocIdSetIterator approximation;
    private final TwoPhaseIterator twoPhaseIterator;
    private final DocIdSetIterator disi;

    public ConstantScoreScorer(float score, ScoreMode scoreMode, DocIdSetIterator disi) {
        this.score = score;
        this.scoreMode = scoreMode;
        this.approximation = scoreMode == ScoreMode.TOP_SCORES ? new DocIdSetIteratorWrapper(this, disi) : disi;
        this.twoPhaseIterator = null;
        this.disi = this.approximation;
    }

    public ConstantScoreScorer(float score, ScoreMode scoreMode, final TwoPhaseIterator twoPhaseIterator) {
        this.score = score;
        this.scoreMode = scoreMode;
        if (scoreMode == ScoreMode.TOP_SCORES) {
            this.approximation = new DocIdSetIteratorWrapper(this, twoPhaseIterator.approximation());
            this.twoPhaseIterator = new TwoPhaseIterator(this, this.approximation){

                @Override
                public boolean matches() throws IOException {
                    return twoPhaseIterator.matches();
                }

                @Override
                public float matchCost() {
                    return twoPhaseIterator.matchCost();
                }
            };
        } else {
            this.approximation = twoPhaseIterator.approximation();
            this.twoPhaseIterator = twoPhaseIterator;
        }
        this.disi = TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.score;
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        if (this.scoreMode == ScoreMode.TOP_SCORES && minScore > this.score) {
            ((DocIdSetIteratorWrapper)this.approximation).delegate = DocIdSetIterator.empty();
        }
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.disi;
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return this.twoPhaseIterator;
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public float score() throws IOException {
        return this.score;
    }

    private class DocIdSetIteratorWrapper
    extends DocIdSetIterator {
        int doc = -1;
        DocIdSetIterator delegate;

        DocIdSetIteratorWrapper(ConstantScoreScorer constantScoreScorer, DocIdSetIterator delegate) {
            this.delegate = delegate;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            this.doc = this.delegate.nextDoc();
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            this.doc = this.delegate.advance(target);
            return this.doc;
        }

        @Override
        public long cost() {
            return this.delegate.cost();
        }
    }
}

