/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import ewewukek.musketmod.GunItem;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import tallestegg.guardvillagers.common.entities.Guard;

public class ModCompat {
    public static HumanoidModel.ArmPose reloadMusketAnim(ItemStack stack, InteractionHand handIn, Guard guard, HumanoidModel.ArmPose bipedmodel$armpose) {
        if (stack.getItem() instanceof GunItem && !GunItem.isLoaded((ItemStack)stack) && handIn == guard.getUsedItemHand()) {
            return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
        }
        return bipedmodel$armpose;
    }

    public static boolean isHoldingMusket(ItemStack stack) {
        return stack.getItem() instanceof GunItem;
    }

    public static HumanoidModel.ArmPose holdMusketAnim(ItemStack stack, Guard guard) {
        if (stack.getItem() instanceof GunItem && GunItem.isLoaded((ItemStack)stack) && guard.isAggressive()) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public static void shootGun(Guard guard) {
        Item item = guard.getMainHandItem().getItem();
        if (item instanceof GunItem) {
            GunItem musketItem = (GunItem)item;
            Vec3 front = Vec3.directionFromRotation((float)guard.getXRot(), (float)guard.getYRot());
            musketItem.fire((LivingEntity)guard, front);
            GunItem.setLoaded((ItemStack)guard.getMainHandItem(), (boolean)false);
            guard.playSound(musketItem.fireSound(), 3.5f, 1.0f);
            guard.damageGuardItem(1, EquipmentSlot.MAINHAND, guard.getMainHandItem());
        }
    }

    public static class UseMusketGoal<T extends PathfinderMob>
    extends Goal {
        private final float attackRadiusSqr;
        private final T mob;
        private int attackIntervalMin;
        private Path path;
        private int attackTime = -1;
        private int seeTime;
        private int timeUntilShoot = 20;

        public UseMusketGoal(T pMob, int pAttackIntervalMin, float pAttackRadius) {
            this.mob = pMob;
            this.attackIntervalMin = pAttackIntervalMin;
            this.attackRadiusSqr = pAttackRadius * pAttackRadius;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity target = this.mob.getTarget();
            return target != null && this.mob.getMainHandItem().getItem() instanceof GunItem;
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public void start() {
            this.mob.setAggressive(true);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity target = this.mob.getTarget();
            if (target != null) {
                double distanceSquared = this.mob.distanceToSqr((Entity)target);
                boolean canSee = this.mob.getSensing().hasLineOfSight((Entity)target);
                boolean seeTimeGreaterThanZero = this.seeTime > 0;
                this.mob.getLookControl().setLookAt((Entity)target);
                this.mob.lookAt((Entity)target, 30.0f, 30.0f);
                if (!canSee && this.seeTime < -60) {
                    this.mob.stopUsingItem();
                }
                if (GunItem.isLoaded((ItemStack)this.mob.getMainHandItem())) {
                    this.mob.stopUsingItem();
                    if (canSee) {
                        --this.timeUntilShoot;
                        if (this.timeUntilShoot <= 0) {
                            ((RangedAttackMob)this.mob).performRangedAttack(target, ((GunItem)this.mob.getMainHandItem().getItem()).bulletSpeed());
                            this.attackTime = this.attackIntervalMin;
                        }
                    }
                } else if (--this.attackTime <= 0 && this.seeTime >= -60 && !GunItem.isLoaded((ItemStack)this.mob.getMainHandItem())) {
                    this.mob.startUsingItem(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof GunItem));
                    this.timeUntilShoot = 20;
                }
                if (canSee != seeTimeGreaterThanZero) {
                    this.seeTime = 0;
                }
                this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
                if (distanceSquared <= 6.0) {
                    this.mob.getMoveControl().strafe(-0.5f, 0.0f);
                }
                if (distanceSquared > (double)this.attackRadiusSqr || this.seeTime < 5) {
                    this.mob.getNavigation().moveTo((Entity)target, 1.0);
                } else if (distanceSquared < (double)this.attackRadiusSqr) {
                    this.mob.getNavigation().stop();
                }
                if (Guard.RangedCrossbowAttackPassiveGoal.friendlyInLineOfSight(this.mob)) {
                    Vec3 vec3 = this.getPosition(this.mob);
                    if (distanceSquared <= (double)this.attackRadiusSqr && vec3 != null && this.mob.getNavigation().isDone()) {
                        this.path = this.mob.getNavigation().createPath(vec3.x, vec3.y, vec3.z, 0);
                        this.mob.getLookControl().setLookAt(vec3.x, this.mob.getEyeY(), vec3.z);
                        if (this.path != null && this.path.canReach()) {
                            this.mob.getNavigation().moveTo(this.path, 0.9);
                            this.attackTime = -1;
                            this.mob.stopUsingItem();
                        }
                    }
                }
            }
        }

        public void stop() {
            this.mob.setAggressive(false);
            this.seeTime = 0;
            this.attackTime = -1;
            this.mob.stopUsingItem();
            this.timeUntilShoot = 20;
        }

        @Nullable
        protected Vec3 getPosition(T mob) {
            if (mob.getTarget() != null) {
                return LandRandomPos.getPosAway(mob, (int)5, (int)7, (Vec3)mob.getTarget().position());
            }
            return LandRandomPos.getPos(mob, (int)5, (int)7);
        }
    }
}

