/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.render.tooltip;

import com.gametechbc.spelllib.item.AbstractLoreItem;
import com.gametechbc.spelllib.utils.GUIColorBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="gtbcs_spell_lib", value={Dist.CLIENT})
public class LoreTooltipRenderer {
    private static final int PREVIEW_TOOLTIP_WIDTH = 280;
    private static long lastFrameTime = 0L;
    private static float animationTime = 0.0f;
    private static GUIColorBuilder colors;

    @SubscribeEvent
    public static void onTooltipRender(RenderTooltipEvent.Pre event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof AbstractLoreItem) {
            AbstractLoreItem loreItem = (AbstractLoreItem)item;
            event.setCanceled(true);
            long currentTime = System.currentTimeMillis();
            if (lastFrameTime != 0L) {
                animationTime += (float)(currentTime - lastFrameTime) / 1000.0f;
            }
            lastFrameTime = currentTime;
            colors = loreItem.getColorSet();
            GuiGraphics guiGraphics = event.getGraphics();
            Font font = event.getFont();
            LoreTooltipRenderer.renderPreviewTooltip(guiGraphics, font, loreItem, stack, event.getX(), event.getY(), event.getScreenWidth(), event.getScreenHeight());
        }
    }

    private static void renderPreviewTooltip(GuiGraphics graphics, Font font, AbstractLoreItem loreItem, ItemStack stack, int mouseX, int mouseY, int screenWidth, int screenHeight) {
        Component itemName = stack.getHoverName();
        AbstractLoreItem.LoreCredits credits = loreItem.getLoreCredits(stack);
        String author = credits != null && !credits.getLoreAuthor().isEmpty() ? credits.getLoreAuthor() : "";
        String modId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace();
        MutableComponent modName = Component.literal((String)modId);
        try {
            String modDisplayName = ModList.get().getModContainerById(modId).map(container -> container.getModInfo().getDisplayName()).orElse(modId);
            modName = Component.literal((String)modDisplayName);
        }
        catch (Exception modDisplayName) {
            // empty catch block
        }
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int fieldCount = 3;
        if (!author.isEmpty()) {
            ++fieldCount;
        }
        int tooltipHeight = 10 + lineHeight * fieldCount + 15;
        int tooltipWidth = 280;
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - 12;
        if (tooltipX + tooltipWidth > screenWidth - 10) {
            tooltipX = screenWidth - tooltipWidth - 10;
        }
        if (tooltipY + tooltipHeight > screenHeight - 10) {
            tooltipY = screenHeight - tooltipHeight - 10;
        }
        if (tooltipX < 10) {
            tooltipX = 10;
        }
        if (tooltipY < 10) {
            tooltipY = 10;
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 400.0f);
        graphics.fill(tooltipX - 1, tooltipY - 1, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight + 1, -267386864);
        LoreTooltipRenderer.fillGradient(graphics, tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, LoreTooltipRenderer.colors.bgBase, LoreTooltipRenderer.colors.bgDark);
        graphics.fill(tooltipX - 1, tooltipY - 1, tooltipX + tooltipWidth + 1, tooltipY, LoreTooltipRenderer.colors.borderAccent);
        graphics.fill(tooltipX - 1, tooltipY + tooltipHeight, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight + 1, LoreTooltipRenderer.colors.borderAccent);
        graphics.fill(tooltipX - 1, tooltipY, tooltipX, tooltipY + tooltipHeight, LoreTooltipRenderer.colors.borderAccent);
        graphics.fill(tooltipX + tooltipWidth, tooltipY, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight, LoreTooltipRenderer.colors.borderAccent);
        int y = tooltipY + 8;
        int leftX = tooltipX + 8;
        graphics.drawString(font, itemName, leftX, y, LoreTooltipRenderer.colors.titleColor, false);
        graphics.fill(leftX, y += lineHeight + 4, tooltipX + tooltipWidth - 8, y + 1, LoreTooltipRenderer.colors.borderAccent);
        y += 6;
        if (!author.isEmpty()) {
            MutableComponent authorLabel = Component.translatable((String)"lore_item.gtbcs_spell_lib.preview.author");
            MutableComponent authorComp = authorLabel.copy().append(": ").append((Component)Component.literal((String)author).withStyle(ChatFormatting.ITALIC));
            graphics.drawString(font, (Component)authorComp, leftX, y, LoreTooltipRenderer.colors.subtitleColor, false);
            y += lineHeight + 2;
        }
        MutableComponent prompt = Component.translatable((String)"lore_item.gtbcs_spell_lib.tooltip.open_prompt").withStyle(ChatFormatting.ITALIC);
        float pulse = (Mth.sin((float)(animationTime * 3.0f)) + 1.0f) / 2.0f;
        int promptAlpha = (int)(150.0f + pulse * 105.0f);
        int promptColor = promptAlpha << 24 | LoreTooltipRenderer.colors.borderHighlight & 0xFFFFFF;
        graphics.drawString(font, (Component)prompt, leftX, y, promptColor, false);
        graphics.drawString(font, (Component)modName, leftX, y += lineHeight + 6, -11184641, false);
        graphics.pose().popPose();
    }

    private static void fillGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(matrix, (float)x2, (float)y1, 0.0f).setColor(colorA);
        builder.addVertex(matrix, (float)x1, (float)y1, 0.0f).setColor(colorA);
        builder.addVertex(matrix, (float)x1, (float)y2, 0.0f).setColor(colorB);
        builder.addVertex(matrix, (float)x2, (float)y2, 0.0f).setColor(colorB);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

