/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.render.screen;

import com.gametechbc.spelllib.init.GSLKeybinds;
import com.gametechbc.spelllib.item.AbstractLoreItem;
import com.gametechbc.spelllib.utils.GUIColorBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class LoreScreenRenderer
extends Screen {
    private static final int MAX_TEXT_WIDTH = 435;
    private static final int PADDING = 24;
    private static final int LINE_HEIGHT = 11;
    private static final int TITLE_SPACING = 28;
    private static final int SUBTITLE_SPACING = 20;
    private static final int SECTION_SPACING = 10;
    private static final int PAGE_INDICATOR_HEIGHT = 20;
    private static final int PAGE_DOT_SIZE = 6;
    private static final int PAGE_DOT_SPACING = 10;
    private static final int PAGE_TOP_SPACING = 35;
    private static final int PAGE_CONTENT_OFFSET = 18;
    private static final int CREDITS_FIELD_SPACING = 15;
    private final ItemStack bookStack;
    private final AbstractLoreItem loreItem;
    private final GUIColorBuilder colors;
    private int currentPage = 0;
    private float animationTime = 0.0f;
    private long lastFrameTime = 0L;

    public LoreScreenRenderer(ItemStack stack) {
        super((Component)Component.empty());
        this.bookStack = stack;
        this.loreItem = (AbstractLoreItem)stack.getItem();
        this.colors = this.loreItem.getColorSet();
    }

    protected void init() {
        super.init();
        this.currentPage = 0;
        this.lastFrameTime = System.currentTimeMillis();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        long currentTime = System.currentTimeMillis();
        if (this.lastFrameTime != 0L) {
            this.animationTime += (float)(currentTime - this.lastFrameTime) / 1000.0f;
        }
        this.lastFrameTime = currentTime;
        super.render(graphics, mouseX, mouseY, partialTick);
        AbstractLoreItem.LorePages lorePages = this.loreItem.getLorePages(this.bookStack);
        AbstractLoreItem.LoreCredits credits = this.loreItem.getLoreCredits(this.bookStack);
        int totalPages = lorePages.getTotalPages();
        if (credits != null) {
            ++totalPages;
        }
        this.currentPage = Mth.clamp((int)this.currentPage, (int)0, (int)totalPages);
        if (this.currentPage == 0) {
            this.renderPreviewPage(graphics);
        } else {
            this.renderContentPage(graphics, lorePages, credits, totalPages);
        }
    }

    private void renderPreviewPage(GuiGraphics graphics) {
        Component itemName = this.bookStack.getHoverName();
        AbstractLoreItem.LoreCredits credits = this.loreItem.getLoreCredits(this.bookStack);
        String author = credits != null && !credits.getLoreAuthor().isEmpty() ? credits.getLoreAuthor() : "";
        String subtitle = this.loreItem.getLoreSubtitle(this.bookStack);
        int screenWidth = 483;
        int screenHeight = 280;
        int screenX = (this.width - screenWidth) / 2;
        int screenY = (this.height - screenHeight) / 2;
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 0.0f);
        this.renderBookBackground(graphics, screenX, screenY, screenWidth, screenHeight);
        this.renderBorders(graphics, screenX, screenY, screenWidth, screenHeight);
        this.renderParticles(graphics, screenX, screenY, screenWidth, screenHeight);
        this.renderCornerStars(graphics, this.font, screenX, screenY, screenWidth, screenHeight);
        int centerX = screenX + screenWidth / 2;
        int contentX = screenX + 24;
        int currentY = screenY + 24 + 30;
        float pulse = (Mth.sin((float)(this.animationTime * 2.0f)) + 1.0f) / 2.0f;
        MutableComponent topOrnament = Component.literal((String)"\u2756");
        int ornamentWidth = this.font.width((FormattedText)topOrnament);
        int ornamentAlpha = (int)(150.0f + pulse * 105.0f);
        int ornamentColor = ornamentAlpha << 24 | this.colors.borderHighlight & 0xFFFFFF;
        graphics.drawString(this.font, (Component)topOrnament, centerX - ornamentWidth / 2, currentY, ornamentColor, false);
        graphics.pose().pushPose();
        float titleScale = 1.5f;
        int titleWidth = (int)((float)this.font.width((FormattedText)itemName) * titleScale);
        graphics.pose().translate((float)(centerX - titleWidth / 2), (float)(currentY += 18), 0.0f);
        graphics.pose().scale(titleScale, titleScale, 1.0f);
        MutableComponent styledName = Component.literal((String)itemName.getString()).withStyle(ChatFormatting.ITALIC);
        int glowAlpha = (int)(50.0f + pulse * 70.0f);
        int glowColor = glowAlpha << 24 | this.colors.titleColor & 0xFFFFFF;
        for (int i = 2; i > 0; --i) {
            int layerAlpha = glowAlpha / (i + 1);
            int layerColor = layerAlpha << 24 | this.colors.titleColor & 0xFFFFFF;
            graphics.drawString(this.font, (Component)styledName, -i, -i, layerColor, false);
            graphics.drawString(this.font, (Component)styledName, i, -i, layerColor, false);
            graphics.drawString(this.font, (Component)styledName, -i, i, layerColor, false);
            graphics.drawString(this.font, (Component)styledName, i, i, layerColor, false);
        }
        graphics.drawString(this.font, (Component)styledName, 0, 0, this.colors.titleColor, false);
        graphics.pose().popPose();
        Objects.requireNonNull(this.font);
        currentY += (int)(9.0f * titleScale) + 18;
        if (!subtitle.isEmpty()) {
            int ornamentMargin = 25;
            int ornamentY = currentY + 6;
            int subtitleWidth = (int)((float)this.font.width(subtitle) * 1.05f);
            int subtitleStartX = centerX - subtitleWidth / 2;
            int subtitleEndX = centerX + subtitleWidth / 2;
            this.renderOrnament(graphics, contentX, ornamentY, subtitleStartX - ornamentMargin);
            this.renderOrnament(graphics, subtitleEndX + ornamentMargin, ornamentY, contentX + 435);
            graphics.pose().pushPose();
            float subtitleScale = 1.05f;
            MutableComponent subtitleComp = Component.literal((String)subtitle).withStyle(ChatFormatting.ITALIC);
            graphics.pose().translate((float)(centerX - subtitleWidth / 2), (float)currentY, 0.0f);
            graphics.pose().scale(subtitleScale, subtitleScale, 1.0f);
            int subtitleGlow = (int)(35.0f + pulse * 45.0f);
            int subtitleGlowColor = subtitleGlow << 24 | this.colors.subtitleColor & 0xFFFFFF;
            graphics.drawString(this.font, (Component)subtitleComp, -1, -1, subtitleGlowColor, false);
            graphics.drawString(this.font, (Component)subtitleComp, 1, -1, subtitleGlowColor, false);
            graphics.drawString(this.font, (Component)subtitleComp, -1, 1, subtitleGlowColor, false);
            graphics.drawString(this.font, (Component)subtitleComp, 1, 1, subtitleGlowColor, false);
            graphics.drawString(this.font, (Component)subtitleComp, 0, 0, this.colors.subtitleColor, false);
            graphics.pose().popPose();
            Objects.requireNonNull(this.font);
            currentY += (int)(9.0f * subtitleScale) + 22;
        }
        int lineWidth = 150;
        int lineAlpha = (int)(100.0f + pulse * 100.0f);
        int lineColor = lineAlpha << 24 | this.colors.borderAccent & 0xFFFFFF;
        for (int i = 0; i < lineWidth; i += 3) {
            float linePulse = (Mth.sin((float)(this.animationTime * 1.5f + (float)i * 0.1f)) + 1.0f) / 2.0f;
            int dotAlpha = (int)(80.0f + linePulse * 120.0f);
            int dotColor = dotAlpha << 24 | this.colors.borderAccent & 0xFFFFFF;
            graphics.fill(centerX - lineWidth / 2 + i, currentY, centerX - lineWidth / 2 + i + 1, currentY + 1, dotColor);
        }
        currentY += 20;
        if (!author.isEmpty()) {
            MutableComponent authorText = Component.literal((String)"~ by ").withStyle(ChatFormatting.ITALIC).append((Component)Component.literal((String)author)).append((Component)Component.literal((String)" ~").withStyle(ChatFormatting.ITALIC));
            int authorWidth = this.font.width((FormattedText)authorText);
            graphics.drawString(this.font, (Component)authorText, centerX - authorWidth / 2, currentY, this.colors.textColor, false);
            Objects.requireNonNull(this.font);
            currentY += 9 + 25;
        } else {
            currentY += 15;
        }
        MutableComponent diamondIcon = Component.literal((String)"\u25c6");
        graphics.pose().pushPose();
        float iconScale = 1.2f;
        int iconWidth = (int)((float)this.font.width((FormattedText)diamondIcon) * iconScale);
        graphics.pose().translate((float)(centerX - iconWidth / 2), (float)currentY, 0.0f);
        graphics.pose().scale(iconScale, iconScale, 1.0f);
        int iconAlpha = (int)(160.0f + pulse * 95.0f);
        int iconColor = iconAlpha << 24 | this.colors.borderHighlight & 0xFFFFFF;
        int iconGlow = 0x32000000 | this.colors.particleColor & 0xFFFFFF;
        graphics.drawString(this.font, (Component)diamondIcon, -2, -2, iconGlow, false);
        graphics.drawString(this.font, (Component)diamondIcon, 2, -2, iconGlow, false);
        graphics.drawString(this.font, (Component)diamondIcon, -2, 2, iconGlow, false);
        graphics.drawString(this.font, (Component)diamondIcon, 2, 2, iconGlow, false);
        graphics.drawString(this.font, (Component)diamondIcon, 0, 0, iconColor, false);
        graphics.pose().popPose();
        MutableComponent prompt = Component.translatable((String)"lore_item.gtbcs_spell_lib.preview.continue.start").append(GSLKeybinds.KEY_ARROW_RIGHT.getTranslatedKeyMessage()).append((Component)Component.translatable((String)"lore_item.gtbcs_spell_lib.preview.continue.end")).withStyle(ChatFormatting.ITALIC);
        int promptWidth = this.font.width((FormattedText)prompt);
        int promptAlpha = (int)(100.0f + pulse * 155.0f);
        int promptColor = promptAlpha << 24 | this.colors.borderHighlight & 0xFFFFFF;
        graphics.drawString(this.font, (Component)prompt, centerX - promptWidth / 2, currentY += 30, promptColor, false);
        graphics.pose().popPose();
    }

    private void renderContentPage(GuiGraphics graphics, AbstractLoreItem.LorePages lorePages, AbstractLoreItem.LoreCredits credits, int totalPages) {
        boolean isCreditsPage = credits != null && this.currentPage == totalPages;
        ArrayList<WrappedParagraph> wrappedParagraphs = new ArrayList<WrappedParagraph>();
        if (!isCreditsPage) {
            List<String> paragraphs = lorePages.getPage(this.currentPage - 1);
            for (String paragraph : paragraphs) {
                wrappedParagraphs.add(this.wrapText(paragraph, this.font, 435));
            }
        }
        int contentHeight = isCreditsPage ? this.calculateCreditsHeight(credits) : this.calculateContentHeight(wrappedParagraphs, totalPages);
        int tooltipWidth = 483;
        int tooltipHeight = contentHeight + 48;
        int tooltipX = (this.width - tooltipWidth) / 2;
        int tooltipY = (this.height - tooltipHeight) / 2;
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 0.0f);
        this.renderBookBackground(graphics, tooltipX, tooltipY, tooltipWidth, tooltipHeight);
        this.renderBorders(graphics, tooltipX, tooltipY, tooltipWidth, tooltipHeight);
        this.renderParticles(graphics, tooltipX, tooltipY, tooltipWidth, tooltipHeight);
        this.renderCornerStars(graphics, this.font, tooltipX, tooltipY, tooltipWidth, tooltipHeight);
        int contentX = tooltipX + 24;
        int contentY = tooltipY + 24;
        if (isCreditsPage) {
            this.renderCreditsPage(graphics, this.font, credits, contentX, contentY, 435);
        } else if (this.currentPage == 1) {
            contentY += this.renderTitle(graphics, this.font, this.loreItem.getLoreTitle(this.bookStack), contentX, contentY, 435);
            contentY += this.renderSubtitle(graphics, this.font, this.loreItem.getLoreSubtitle(this.bookStack), contentX, contentY, 435);
            for (int i = 0; i < wrappedParagraphs.size(); ++i) {
                contentY += this.renderParagraph(graphics, this.font, (WrappedParagraph)wrappedParagraphs.get(i), contentX, contentY, i == 0, this.loreItem.getFirstWordMargin());
                contentY += 10;
            }
        } else {
            this.renderPageDecorator(graphics, this.font, contentX, contentY, 435);
            contentY += 18;
            for (WrappedParagraph para : wrappedParagraphs) {
                contentY += this.renderParagraph(graphics, this.font, para, contentX, contentY, false, 0);
                contentY += 10;
            }
        }
        if (this.currentPage > 0 && totalPages > 1) {
            this.renderPageIndicators(graphics, this.font, tooltipX, tooltipY + tooltipHeight - 24 - 10, tooltipWidth, this.currentPage, totalPages);
        }
        graphics.pose().popPose();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        AbstractLoreItem.LorePages lorePages = this.loreItem.getLorePages(this.bookStack);
        AbstractLoreItem.LoreCredits credits = this.loreItem.getLoreCredits(this.bookStack);
        int totalPages = lorePages.getTotalPages();
        if (credits != null) {
            ++totalPages;
        }
        if (GSLKeybinds.KEY_ARROW_RIGHT.matches(keyCode, scanCode) && this.currentPage < totalPages) {
            ++this.currentPage;
            return true;
        }
        if (GSLKeybinds.KEY_ARROW_LEFT.matches(keyCode, scanCode) && this.currentPage > 0) {
            --this.currentPage;
            return true;
        }
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            AbstractLoreItem.LorePages lorePages = this.loreItem.getLorePages(this.bookStack);
            AbstractLoreItem.LoreCredits credits = this.loreItem.getLoreCredits(this.bookStack);
            int totalPages = lorePages.getTotalPages();
            if (credits != null) {
                ++totalPages;
            }
            if (this.currentPage < totalPages) {
                ++this.currentPage;
                return true;
            }
        } else if (button == 1 && this.currentPage > 0) {
            --this.currentPage;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void renderBookBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        this.fillGradient(graphics, x - 8, y - 8, x + width + 8, y + height + 8, Integer.MIN_VALUE, 0x40000000);
        this.fillGradient(graphics, x - 4, y - 4, x + width + 4, y + height + 4, -1610612736, 0x60000000);
        graphics.fill(x, y, x + width, y + height, this.colors.bgDark);
        this.fillGradient(graphics, x, y, x + width, y + height / 2, this.colors.bgBase, this.colors.bgDark);
        this.fillGradient(graphics, x, y + height / 2, x + width, y + height, this.colors.bgDark, this.colors.bgDark);
        int smoothWidth = width / 4;
        this.fillGradientHorizontal(graphics, x, y, x + smoothWidth, y + height, 0x30000000, 0);
        int vignetteSize = 25;
        this.fillGradient(graphics, x, y, x + width, y + vignetteSize, 0x30000000, 0);
        this.fillGradient(graphics, x, y + height - vignetteSize, x + width, y + height, 0, 0x30000000);
        this.fillGradientHorizontal(graphics, x + width - vignetteSize, y, x + width, y + height, 0, 0x30000000);
    }

    private void renderBorders(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.fill(x - 3, y - 3, x + width + 3, y - 2, this.colors.borderDark);
        graphics.fill(x - 3, y + height + 2, x + width + 3, y + height + 3, this.colors.borderDark);
        graphics.fill(x - 3, y - 2, x - 2, y + height + 2, this.colors.borderDark);
        graphics.fill(x + width + 2, y - 2, x + width + 3, y + height + 2, this.colors.borderDark);
        graphics.fill(x - 2, y - 2, x + width + 2, y - 1, this.colors.borderAccent);
        graphics.fill(x - 2, y + height + 1, x + width + 2, y + height + 2, this.colors.borderAccent);
        graphics.fill(x - 2, y - 1, x - 1, y + height + 1, this.colors.borderAccent);
        graphics.fill(x + width + 1, y - 1, x + width + 2, y + height + 1, this.colors.borderAccent);
        graphics.fill(x - 1, y - 1, x + width + 1, y, this.colors.borderHighlight);
        graphics.fill(x - 1, y + height, x + width + 1, y + height + 1, this.colors.borderHighlight);
        graphics.fill(x - 1, y, x, y + height, this.colors.borderHighlight);
        graphics.fill(x + width, y, x + width + 1, y + height, this.colors.borderHighlight);
        int cornerSize = 12;
        int cornerThick = 2;
        graphics.fill(x - 5, y - 5, x - 5 + cornerSize, y - 5 + cornerThick, this.colors.borderHighlight);
        graphics.fill(x - 5, y - 5, x - 5 + cornerThick, y - 5 + cornerSize, this.colors.borderHighlight);
        graphics.fill(x + width + 5 - cornerSize, y - 5, x + width + 5, y - 5 + cornerThick, this.colors.borderHighlight);
        graphics.fill(x + width + 5 - cornerThick, y - 5, x + width + 5, y - 5 + cornerSize, this.colors.borderHighlight);
        graphics.fill(x - 5, y + height + 5 - cornerThick, x - 5 + cornerSize, y + height + 5, this.colors.borderHighlight);
        graphics.fill(x - 5, y + height + 5 - cornerSize, x - 5 + cornerThick, y + height + 5, this.colors.borderHighlight);
        graphics.fill(x + width + 5 - cornerSize, y + height + 5 - cornerThick, x + width + 5, y + height + 5, this.colors.borderHighlight);
        graphics.fill(x + width + 5 - cornerThick, y + height + 5 - cornerSize, x + width + 5, y + height + 5, this.colors.borderHighlight);
        float pulse = (Mth.sin((float)(this.animationTime * 2.0f)) + 1.0f) / 2.0f;
        int accentAlpha = (int)(100.0f + pulse * 155.0f);
        int accentColor = accentAlpha << 24 | this.colors.particleColor & 0xFFFFFF;
        int accentWidth = 30;
        graphics.fill(x + width / 2 - accentWidth / 2, y - 4, x + width / 2 + accentWidth / 2, y - 3, accentColor);
        graphics.fill(x + width / 2 - accentWidth / 2, y + height + 3, x + width / 2 + accentWidth / 2, y + height + 4, accentColor);
        int accentHeight = 30;
        graphics.fill(x - 4, y + height / 2 - accentHeight / 2, x - 3, y + height / 2 + accentHeight / 2, accentColor);
        graphics.fill(x + width + 3, y + height / 2 - accentHeight / 2, x + width + 4, y + height / 2 + accentHeight / 2, accentColor);
        int dotSize = 2;
        graphics.fill(x + width / 2 - 1, y - 5, x + width / 2 + 1, y - 5 + dotSize, accentColor);
        graphics.fill(x + width / 2 - 1, y + height + 5 - dotSize, x + width / 2 + 1, y + height + 5, accentColor);
        graphics.fill(x - 5, y + height / 2 - 1, x - 5 + dotSize, y + height / 2 + 1, accentColor);
        graphics.fill(x + width + 5 - dotSize, y + height / 2 - 1, x + width + 5, y + height / 2 + 1, accentColor);
    }

    private void renderParticles(GuiGraphics graphics, int x, int y, int width, int height) {
        for (int i = 0; i < 20; ++i) {
            float offsetX = (float)(Math.sin(this.animationTime * 0.5f + (float)i * 0.3f) * 20.0 + (double)(i * 23 % width));
            float offsetY = (this.animationTime * 10.0f + (float)(i * 17)) % (float)height;
            float alpha = (Mth.sin((float)(this.animationTime * 2.0f + (float)i)) + 1.0f) / 2.0f;
            int particleAlpha = (int)(alpha * 180.0f);
            int particleColor = particleAlpha << 24 | this.colors.particleColor & 0xFFFFFF;
            graphics.fill(x + (int)offsetX, y + (int)offsetY, x + (int)offsetX + 2, y + (int)offsetY + 2, particleColor);
        }
    }

    private void renderCornerStars(GuiGraphics graphics, Font font, int x, int y, int width, int height) {
        MutableComponent star = Component.literal((String)"\u25c6");
        int offset = 6;
        float pulse = (Mth.sin((float)(this.animationTime * 2.5f)) + 1.0f) / 2.0f;
        int glowAlpha = (int)(120.0f + pulse * 135.0f);
        this.renderStar(graphics, font, (Component)star, x + offset, y + offset, glowAlpha);
        this.renderStar(graphics, font, (Component)star, x + width - offset - (int)((float)font.width((FormattedText)star) * 0.9f), y + offset, glowAlpha);
        Objects.requireNonNull(font);
        this.renderStar(graphics, font, (Component)star, x + offset, y + height - offset - (int)(9.0f * 0.9f), glowAlpha);
        int n = x + width - offset - (int)((float)font.width((FormattedText)star) * 0.9f);
        Objects.requireNonNull(font);
        this.renderStar(graphics, font, (Component)star, n, y + height - offset - (int)(9.0f * 0.9f), glowAlpha);
    }

    private void renderStar(GuiGraphics graphics, Font font, Component symbol, int x, int y, int glowAlpha) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 0.0f);
        graphics.pose().scale(0.9f, 0.9f, 1.0f);
        int outerColor = glowAlpha / 2 << 24 | this.colors.borderDark & 0xFFFFFF;
        int innerColor = glowAlpha << 24 | this.colors.borderAccent & 0xFFFFFF;
        graphics.drawString(font, symbol, -2, -2, outerColor, false);
        graphics.drawString(font, symbol, 2, -2, outerColor, false);
        graphics.drawString(font, symbol, -2, 2, outerColor, false);
        graphics.drawString(font, symbol, 2, 2, outerColor, false);
        graphics.drawString(font, symbol, -1, -1, innerColor, false);
        graphics.drawString(font, symbol, 1, -1, innerColor, false);
        graphics.drawString(font, symbol, -1, 1, innerColor, false);
        graphics.drawString(font, symbol, 1, 1, innerColor, false);
        graphics.drawString(font, symbol, 0, 0, this.colors.borderHighlight, false);
        graphics.pose().popPose();
    }

    private int renderTitle(GuiGraphics graphics, Font font, String text, int x, int y, int maxWidth) {
        graphics.pose().pushPose();
        int scaledWidth = (int)((float)font.width(text) * 1.3f);
        int centeredX = x + (maxWidth - scaledWidth) / 2;
        graphics.pose().translate((float)centeredX, (float)y, 0.0f);
        graphics.pose().scale(1.3f, 1.3f, 1.0f);
        MutableComponent styled = Component.literal((String)text).withStyle(ChatFormatting.ITALIC);
        float pulse = (Mth.sin((float)(this.animationTime * 2.0f)) + 1.0f) / 2.0f;
        int glowAlpha = (int)(40.0f + pulse * 60.0f);
        int glowColor = glowAlpha << 24 | this.colors.titleColor & 0xFFFFFF;
        for (int i = 2; i > 0; --i) {
            graphics.drawString(font, (Component)styled, -i, -i, glowColor, false);
            graphics.drawString(font, (Component)styled, i, -i, glowColor, false);
            graphics.drawString(font, (Component)styled, -i, i, glowColor, false);
            graphics.drawString(font, (Component)styled, i, i, glowColor, false);
        }
        graphics.drawString(font, (Component)styled, 0, 0, this.colors.titleColor, false);
        graphics.pose().popPose();
        return 28;
    }

    private int renderSubtitle(GuiGraphics graphics, Font font, String text, int x, int y, int maxWidth) {
        graphics.pose().pushPose();
        float scale = 1.05f;
        int scaledWidth = (int)((float)font.width(text) * scale);
        int centeredX = x + (maxWidth - scaledWidth) / 2;
        int ornamentMargin = 12;
        Objects.requireNonNull(font);
        int ornamentY = y + (int)(9.0f * scale / 2.0f);
        this.renderOrnament(graphics, x, ornamentY, centeredX - ornamentMargin);
        this.renderOrnament(graphics, centeredX + scaledWidth + ornamentMargin, ornamentY, x + maxWidth);
        graphics.pose().translate((float)centeredX, (float)y, 0.0f);
        graphics.pose().scale(scale, scale, 1.0f);
        MutableComponent styled = Component.literal((String)text).withStyle(ChatFormatting.ITALIC);
        float pulse = (Mth.sin((float)(this.animationTime * 2.5f)) + 1.0f) / 2.0f;
        int glowAlpha = (int)(30.0f + pulse * 50.0f);
        int glowColor = glowAlpha << 24 | this.colors.subtitleColor & 0xFFFFFF;
        graphics.drawString(font, (Component)styled, -1, -1, glowColor, false);
        graphics.drawString(font, (Component)styled, 1, -1, glowColor, false);
        graphics.drawString(font, (Component)styled, -1, 1, glowColor, false);
        graphics.drawString(font, (Component)styled, 1, 1, glowColor, false);
        graphics.drawString(font, (Component)styled, 0, 0, this.colors.subtitleColor, false);
        graphics.pose().popPose();
        return 20;
    }

    private void renderOrnament(GuiGraphics graphics, int startX, int y, int endX) {
        int i;
        int length = Math.abs(endX - startX);
        float flow = this.animationTime * 1.5f;
        for (i = 0; i < length; i += 2) {
            float brightness = (Mth.sin((float)(flow + (float)i * 0.15f)) + 1.0f) / 2.0f;
            int alpha = (int)(80.0f + brightness * 120.0f);
            int color = alpha << 24 | this.colors.borderAccent & 0xFFFFFF;
            graphics.fill(startX + i, y, startX + i + 1, y + 1, color);
        }
        for (i = 0; i < 3; ++i) {
            float position = (float)(i + 1) / 4.0f;
            int dotX = startX + (int)((float)length * position);
            float dotPulse = (Mth.sin((float)(this.animationTime * 2.0f + (float)i * 0.5f)) + 1.0f) / 2.0f;
            int dotAlpha = (int)(150.0f + dotPulse * 105.0f);
            int dotColor = dotAlpha << 24 | this.colors.particleColor & 0xFFFFFF;
            graphics.fill(dotX, y - 1, dotX + 1, y, dotColor);
            graphics.fill(dotX - 1, y, dotX + 2, y + 1, dotColor);
            graphics.fill(dotX, y + 1, dotX + 1, y + 2, dotColor);
        }
    }

    private void renderPageDecorator(GuiGraphics graphics, Font font, int x, int y, int width) {
        float pulse = (Mth.sin((float)(this.animationTime * 2.0f)) + 1.0f) / 2.0f;
        int lineAlpha = (int)(120.0f + pulse * 135.0f);
        int lineColor = lineAlpha << 24 | this.colors.borderAccent & 0xFFFFFF;
        int centerX = x + width / 2;
        int lineWidth = 80;
        graphics.fill(centerX - lineWidth / 2, y, centerX + lineWidth / 2, y + 1, lineColor);
        MutableComponent ornament = Component.literal((String)"\u2756");
        int ornamentWidth = font.width((FormattedText)ornament);
        graphics.drawString(font, (Component)ornament, centerX - ornamentWidth / 2, y - 4, this.colors.borderHighlight, false);
    }

    private void renderPageIndicators(GuiGraphics graphics, Font font, int x, int y, int width, int page, int totalPages) {
        if (page == 0) {
            return;
        }
        int totalWidth = totalPages * 6 + (totalPages - 1) * 10;
        int startX = x + (width - totalWidth) / 2;
        float pulse = (Mth.sin((float)(this.animationTime * 3.0f)) + 1.0f) / 2.0f;
        for (int i = 1; i <= totalPages; ++i) {
            MutableComponent dot;
            int dotX = startX + (i - 1) * 16;
            int dotY = y + 1;
            if (i == page) {
                dot = Component.literal((String)"\u25cf");
                int glowAlpha = (int)(220.0f + pulse * 35.0f);
                int activeColor = glowAlpha << 24 | this.colors.borderHighlight & 0xFFFFFF;
                int glowColor = 0x50000000 | this.colors.particleColor & 0xFFFFFF;
                graphics.drawString(font, (Component)dot, dotX - 2, dotY - 2, glowColor, false);
                graphics.drawString(font, (Component)dot, dotX + 2, dotY - 2, glowColor, false);
                graphics.drawString(font, (Component)dot, dotX - 2, dotY + 2, glowColor, false);
                graphics.drawString(font, (Component)dot, dotX + 2, dotY + 2, glowColor, false);
                graphics.drawString(font, (Component)dot, dotX, dotY, activeColor, false);
                continue;
            }
            dot = Component.literal((String)"\u25cb");
            int inactiveColor = 0xB4000000 | this.colors.borderBase & 0xFFFFFF;
            graphics.drawString(font, (Component)dot, dotX, dotY, inactiveColor, false);
        }
        int arrowAlpha = (int)(120.0f + pulse * 135.0f);
        int arrowColor = arrowAlpha << 24 | this.colors.subtitleColor & 0xFFFFFF;
        if (page > 1) {
            graphics.drawString(font, (Component)Component.literal((String)"\u25c4"), startX - 20, y, arrowColor, false);
        }
        if (page < totalPages) {
            graphics.drawString(font, (Component)Component.literal((String)"\u25ba"), startX + totalWidth + 12, y, arrowColor, false);
        }
    }

    private int calculateContentHeight(List<WrappedParagraph> paragraphs, int totalPages) {
        int height = this.currentPage == 1 ? 48 : 35;
        for (WrappedParagraph para : paragraphs) {
            height += para.lines.size() * 11 + 10;
        }
        if (totalPages > 1) {
            height += 20;
        }
        return height;
    }

    private int calculateCreditsHeight(AbstractLoreItem.LoreCredits credits) {
        int height = 50;
        if (!credits.getDocumentName().isEmpty()) {
            height += 15;
        }
        if (!credits.getLoreAuthor().isEmpty()) {
            height += 15;
        }
        if (!credits.getOriginalAuthor().isEmpty()) {
            height += 15;
        }
        if (!credits.getCredits().isEmpty()) {
            height += 15;
        }
        if (!credits.getVolume().isEmpty()) {
            height += 15;
        }
        if (!credits.getWrittenDate().isEmpty()) {
            height += 15;
        }
        if (!credits.getLastUpdated().isEmpty()) {
            height += 15;
        }
        height += 15;
        return height += 20;
    }

    private void renderCreditsPage(GuiGraphics graphics, Font font, AbstractLoreItem.LoreCredits credits, int x, int y, int maxWidth) {
        int centerX = x + maxWidth / 2;
        MutableComponent creditsTitle = Component.literal((String)"\u25c6 ").append((Component)Component.translatable((String)"lore_item.gtbcs_spell_lib.credits.title")).append(" \u25c6");
        int titleWidth = font.width((FormattedText)creditsTitle);
        graphics.pose().pushPose();
        graphics.pose().translate((float)(centerX - titleWidth / 2), (float)(y += 15), 0.0f);
        graphics.pose().scale(1.15f, 1.15f, 1.0f);
        float pulse = (Mth.sin((float)(this.animationTime * 2.0f)) + 1.0f) / 2.0f;
        int glowAlpha = (int)(50.0f + pulse * 70.0f);
        int glowColor = glowAlpha << 24 | this.colors.titleColor & 0xFFFFFF;
        graphics.drawString(font, (Component)creditsTitle, -1, -1, glowColor, false);
        graphics.drawString(font, (Component)creditsTitle, 1, -1, glowColor, false);
        graphics.drawString(font, (Component)creditsTitle, -1, 1, glowColor, false);
        graphics.drawString(font, (Component)creditsTitle, 1, 1, glowColor, false);
        graphics.drawString(font, (Component)creditsTitle, 0, 0, this.colors.titleColor, false);
        graphics.pose().popPose();
        y += 25;
        if (!credits.getDocumentName().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.gtbcs_spell_lib.credits.document", credits.getDocumentName(), x, y, maxWidth);
        }
        if (!credits.getLoreAuthor().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.gtbcs_spell_lib.credits.lore_author", credits.getLoreAuthor(), x, y, maxWidth);
        }
        if (!credits.getOriginalAuthor().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.gtbcs_spell_lib.credits.original_author", credits.getOriginalAuthor(), x, y, maxWidth);
        }
        if (!credits.getCredits().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.gtbcs_spell_lib.credits.credits", credits.getCredits(), x, y, maxWidth);
        }
        if (!credits.getVolume().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.gtbcs_spell_lib.credits.volume", credits.getVolume(), x, y, maxWidth);
        }
        if (!credits.getWrittenDate().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.gtbcs_spell_lib.credits.written_date", credits.getWrittenDate(), x, y, maxWidth);
        }
        if (!credits.getLastUpdated().isEmpty()) {
            this.renderCreditsField(graphics, font, "lore_item.gtbcs_spell_lib.credits.last_updated", credits.getLastUpdated(), x, y, maxWidth);
        }
    }

    private int renderCreditsField(GuiGraphics graphics, Font font, String labelKey, String value, int x, int y, int maxWidth) {
        MutableComponent labelComp = Component.translatable((String)labelKey).withStyle(ChatFormatting.ITALIC);
        MutableComponent valueComp = Component.literal((String)value);
        int labelWidth = font.width((FormattedText)labelComp);
        int valueWidth = font.width((FormattedText)valueComp);
        int totalWidth = labelWidth + 10 + valueWidth;
        int startX = x + (maxWidth - totalWidth) / 2;
        MutableComponent dot = Component.literal((String)"\u2022");
        graphics.drawString(font, (Component)dot, startX - 8, y, this.colors.borderAccent, false);
        graphics.drawString(font, (Component)labelComp, startX, y, this.colors.subtitleColor, false);
        graphics.drawString(font, (Component)valueComp, startX + labelWidth + 10, y, this.colors.textColor, false);
        return 15;
    }

    private int renderParagraph(GuiGraphics graphics, Font font, WrappedParagraph paragraph, int x, int y, boolean stylizeFirst, int firstWordMargin) {
        int currentY = y;
        for (int lineIdx = 0; lineIdx < paragraph.lines.size(); ++lineIdx) {
            String line = paragraph.lines.get(lineIdx);
            if (stylizeFirst && lineIdx == 0 && !line.isEmpty()) {
                int spaceIndex = line.indexOf(32);
                String firstWord = spaceIndex > 0 ? line.substring(0, spaceIndex) : line;
                String restOfLine = spaceIndex > 0 ? line.substring(spaceIndex + 1) : "";
                MutableComponent firstWordComp = Component.literal((String)firstWord).withStyle(ChatFormatting.BOLD);
                float dropCapScale = 1.3f;
                graphics.pose().pushPose();
                graphics.pose().translate((float)x, (float)(currentY - 2), 0.0f);
                graphics.pose().scale(dropCapScale, dropCapScale, 1.0f);
                for (int i = 2; i >= 0; --i) {
                    int glowAlpha = 60 - i * 20;
                    int glowColor = glowAlpha << 24 | this.colors.particleColor & 0xFFFFFF;
                    graphics.drawString(font, (Component)firstWordComp, -i, -i, glowColor, false);
                    graphics.drawString(font, (Component)firstWordComp, i, -i, glowColor, false);
                    graphics.drawString(font, (Component)firstWordComp, -i, i, glowColor, false);
                    graphics.drawString(font, (Component)firstWordComp, i, i, glowColor, false);
                }
                graphics.drawString(font, (Component)firstWordComp, 0, 0, this.colors.firstWordColor, true);
                graphics.pose().popPose();
                int firstWordWidth = (int)((float)font.width(firstWord) * dropCapScale);
                MutableComponent restComp = Component.literal((String)restOfLine);
                graphics.drawString(font, (Component)restComp, x + firstWordWidth + firstWordMargin, currentY + 1, this.colors.textColor, false);
                currentY += 14;
                continue;
            }
            graphics.drawString(font, (Component)Component.literal((String)line), x, currentY, this.colors.textColor, false);
            currentY += 11;
        }
        return currentY - y;
    }

    private WrappedParagraph wrapText(String text, Font font, int maxWidth) {
        String[] words = text.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.isEmpty() ? word : String.valueOf(currentLine) + " " + word;
            if (font.width(testLine) <= maxWidth) {
                if (!currentLine.isEmpty()) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (!currentLine.isEmpty()) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine.toString());
        }
        return new WrappedParagraph(lines);
    }

    private void fillGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(matrix, (float)x2, (float)y1, 0.0f).setColor(colorA);
        builder.addVertex(matrix, (float)x1, (float)y1, 0.0f).setColor(colorA);
        builder.addVertex(matrix, (float)x1, (float)y2, 0.0f).setColor(colorB);
        builder.addVertex(matrix, (float)x2, (float)y2, 0.0f).setColor(colorB);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private void fillGradientHorizontal(GuiGraphics graphics, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(matrix, (float)x2, (float)y1, 0.0f).setColor(colorB);
        builder.addVertex(matrix, (float)x1, (float)y1, 0.0f).setColor(colorA);
        builder.addVertex(matrix, (float)x1, (float)y2, 0.0f).setColor(colorA);
        builder.addVertex(matrix, (float)x2, (float)y2, 0.0f).setColor(colorB);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private static class WrappedParagraph {
        final List<String> lines;

        WrappedParagraph(List<String> lines) {
            this.lines = lines;
        }
    }
}

