/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class GSLRenderEmissiveLayer<T extends GeoAnimatable>
extends GeoRenderLayer<T> {
    private final Function<T, ResourceLocation> textureFunction;
    private final ResourceLocation staticTexture;
    private final RenderType staticRenderType;
    private final float alpha;
    private final Vector3f color;
    private final int packedLight;
    private final int packedOverlay;
    private final Predicate<T> shouldRender;
    private final Function<T, RenderType> renderTypeFunction;

    private GSLRenderEmissiveLayer(Builder<T> builder) {
        super(builder.renderer);
        this.staticTexture = builder.staticTexture;
        this.staticRenderType = builder.staticRenderType;
        this.textureFunction = builder.textureFunction;
        this.renderTypeFunction = builder.renderTypeFunction;
        this.alpha = builder.alpha;
        this.color = new Vector3f(builder.red, builder.green, builder.blue);
        this.packedLight = builder.packedLight;
        this.packedOverlay = builder.packedOverlay;
        this.shouldRender = builder.shouldRender;
    }

    public GSLRenderEmissiveLayer(GeoRenderer<T> renderer, RenderType renderType, float alpha) {
        this(renderer, renderType, alpha, 1.0f, 1.0f, 1.0f);
    }

    public GSLRenderEmissiveLayer(GeoRenderer<T> renderer, RenderType renderType, float alpha, float red, float green, float blue) {
        this(renderer, renderType, alpha, red, green, blue, 0xF000F0, OverlayTexture.NO_OVERLAY);
    }

    public GSLRenderEmissiveLayer(GeoRenderer<T> renderer, RenderType renderType, float alpha, float red, float green, float blue, int packedLight, int packedOverlay) {
        this(renderer, renderType, alpha, red, green, blue, packedLight, packedOverlay, null);
    }

    public GSLRenderEmissiveLayer(GeoRenderer<T> renderer, RenderType renderType, float alpha, float red, float green, float blue, int packedLight, int packedOverlay, Predicate<T> shouldRender) {
        super(renderer);
        this.staticRenderType = renderType;
        this.staticTexture = null;
        this.textureFunction = null;
        this.renderTypeFunction = null;
        this.alpha = alpha;
        this.color = new Vector3f(red, green, blue);
        this.packedLight = packedLight;
        this.packedOverlay = packedOverlay;
        this.shouldRender = shouldRender;
    }

    public GSLRenderEmissiveLayer(GeoRenderer<T> renderer, RenderType renderType, float alpha, int hexColor) {
        this(renderer, renderType, alpha, (float)(hexColor >> 16 & 0xFF) / 255.0f, (float)(hexColor >> 8 & 0xFF) / 255.0f, (float)(hexColor & 0xFF) / 255.0f);
    }

    public GSLRenderEmissiveLayer(GeoRenderer<T> renderer, ResourceLocation texture, float alpha) {
        this(new Builder<T>(renderer).staticTexture(texture).alpha(alpha));
    }

    public GSLRenderEmissiveLayer(GeoRenderer<T> renderer, ResourceLocation texture, float alpha, float red, float green, float blue) {
        this(new Builder<T>(renderer).staticTexture(texture).alpha(alpha).color(red, green, blue));
    }

    public GSLRenderEmissiveLayer(GeoRenderer<T> renderer, ResourceLocation texture, float alpha, float red, float green, float blue, int packedLight, int packedOverlay) {
        this(new Builder<T>(renderer).staticTexture(texture).alpha(alpha).color(red, green, blue).lighting(packedLight, packedOverlay));
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        RenderType emissiveRenderType;
        if (this.shouldRender != null && !this.shouldRender.test(animatable)) {
            return;
        }
        if (this.staticRenderType != null) {
            emissiveRenderType = this.staticRenderType;
        } else if (this.renderTypeFunction != null) {
            emissiveRenderType = this.renderTypeFunction.apply(animatable);
        } else {
            ResourceLocation texture = this.textureFunction != null ? this.textureFunction.apply(animatable) : this.staticTexture;
            emissiveRenderType = RenderType.eyes((ResourceLocation)texture);
        }
        VertexConsumer vertexConsumer = bufferSource.getBuffer(emissiveRenderType);
        poseStack.pushPose();
        int packedRGB = Utils.packRGB((Vector3f)this.color);
        this.getRenderer().actuallyRender(poseStack, animatable, bakedModel, emissiveRenderType, bufferSource, vertexConsumer, true, partialTick, this.packedLight, this.packedOverlay, packedRGB);
        poseStack.popPose();
    }

    public static <T extends GeoAnimatable> GSLRenderEmissiveLayer<T> fullBright(GeoRenderer<T> renderer, ResourceLocation texture, float alpha) {
        return new Builder<T>(renderer).staticTexture(texture).alpha(alpha).fullBright().build();
    }

    public static <T extends GeoAnimatable> GSLRenderEmissiveLayer<T> colored(GeoRenderer<T> renderer, ResourceLocation texture, float alpha, int hexColor) {
        return new Builder<T>(renderer).staticTexture(texture).alpha(alpha).hexColor(hexColor).fullBright().build();
    }

    public static <T extends GeoAnimatable> GSLRenderEmissiveLayer<T> dynamicTexture(GeoRenderer<T> renderer, Function<T, ResourceLocation> textureFunction, float alpha) {
        return new Builder<T>(renderer).dynamicTexture(textureFunction).alpha(alpha).fullBright().build();
    }

    public static <T extends GeoAnimatable> GSLRenderEmissiveLayer<T> dynamicRenderType(GeoRenderer<T> renderer, Function<T, RenderType> renderTypeFunction, float alpha) {
        return new Builder<T>(renderer).dynamicRenderType(renderTypeFunction).alpha(alpha).fullBright().build();
    }

    public static class Builder<T extends GeoAnimatable> {
        private final GeoRenderer<T> renderer;
        private ResourceLocation staticTexture;
        private RenderType staticRenderType;
        private Function<T, ResourceLocation> textureFunction;
        private Function<T, RenderType> renderTypeFunction;
        private float alpha = 1.0f;
        private float red = 1.0f;
        private float green = 1.0f;
        private float blue = 1.0f;
        private int packedLight = 0xF000F0;
        private int packedOverlay = OverlayTexture.NO_OVERLAY;
        private Predicate<T> shouldRender;

        public Builder(GeoRenderer<T> renderer) {
            this.renderer = renderer;
        }

        public Builder<T> staticTexture(ResourceLocation texture) {
            this.staticTexture = texture;
            this.staticRenderType = null;
            this.textureFunction = null;
            this.renderTypeFunction = null;
            return this;
        }

        public Builder<T> staticRenderType(RenderType renderType) {
            this.staticRenderType = renderType;
            this.staticTexture = null;
            this.textureFunction = null;
            this.renderTypeFunction = null;
            return this;
        }

        public Builder<T> dynamicTexture(Function<T, ResourceLocation> textureFunction) {
            this.textureFunction = textureFunction;
            this.staticTexture = null;
            this.staticRenderType = null;
            this.renderTypeFunction = null;
            return this;
        }

        public Builder<T> dynamicRenderType(Function<T, RenderType> renderTypeFunction) {
            this.renderTypeFunction = renderTypeFunction;
            this.textureFunction = null;
            this.staticTexture = null;
            this.staticRenderType = null;
            return this;
        }

        public Builder<T> alpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder<T> color(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            return this;
        }

        public Builder<T> hexColor(int hexColor) {
            this.red = (float)(hexColor >> 16 & 0xFF) / 255.0f;
            this.green = (float)(hexColor >> 8 & 0xFF) / 255.0f;
            this.blue = (float)(hexColor & 0xFF) / 255.0f;
            return this;
        }

        public Builder<T> lighting(int packedLight, int packedOverlay) {
            this.packedLight = packedLight;
            this.packedOverlay = packedOverlay;
            return this;
        }

        public Builder<T> fullBright() {
            this.packedLight = 0xF000F0;
            return this;
        }

        public Builder<T> condition(Predicate<T> shouldRender) {
            this.shouldRender = shouldRender;
            return this;
        }

        public GSLRenderEmissiveLayer<T> build() {
            return new GSLRenderEmissiveLayer(this);
        }
    }
}

