/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.item.test_items;

import com.gametechbc.spelllib.init.GSLGUIColorThemes;
import com.gametechbc.spelllib.item.AbstractLoreItem;
import com.gametechbc.spelllib.network.OpenLoreScreenPacket;
import com.gametechbc.spelllib.utils.GUIColorBuilder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ExampleLoreItem
extends AbstractLoreItem {
    public ExampleLoreItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.RARE).fireResistant());
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenLoreScreenPacket(hand), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    @Override
    public String getLoreTitle(ItemStack stack) {
        return "Codex Exemplaris";
    }

    @Override
    public String getLoreSubtitle(ItemStack stack) {
        return "A demonstration of the lore system";
    }

    @Override
    public AbstractLoreItem.LorePages getLorePages(ItemStack stack) {
        return AbstractLoreItem.LorePages.builder().page("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc condimentum vulputate dolor vitae dictum. Aliquam posuere dolor ac ultrices facilisis.", "Integer consequat sapien ipsum, a consectetur nulla mollis ut. Nullam ultricies, sem at tincidunt pretium, leo tortor dictum nulla, condimentum sollicitudin felis mi vel dui.").page("Sed suscipit metus a neque euismod, facilisis facilisis elit fringilla. Integer sapien tortor, porttitor ornare justo vel, scelerisque hendrerit risus.", "Phasellus nec nulla rhoncus, sollicitudin magna eget, dapibus mauris. Suspendisse a fermentum sem. Nam ut posuere dolor.").page("Donec pharetra consequat ullamcorper. Nulla laoreet orci tincidunt lacinia suscipit. Donec porta suscipit nulla, vitae dignissim libero congue sed.", "Donec malesuada ante at lectus tempor mollis. Curabitur vulputate, enim at semper maximus, velit dui sodales massa, sit amet blandit erat arcu sed augue.").page("Vivamus dignissim magna enim, ac feugiat sapien pellentesque ac. Curabitur hendrerit id nibh ut laoreet. Vestibulum in porta enim, id elementum nulla.", "Nulla est nunc, faucibus malesuada volutpat eget, viverra sit amet mi. Pellentesque ac lectus sollicitudin est lobortis posuere sed eleifend diam.").page("Vestibulum sit amet porta magna. Vestibulum aliquet, ante eget ornare pretium, erat purus posuere tortor, semper rutrum velit odio nec velit.", "Donec at pretium nisi, eu finibus nisi. The demonstration concludes here, showcasing the multi-page lore system with proper text wrapping and navigation.").build();
    }

    @Override
    public AbstractLoreItem.LoreCredits getLoreCredits(ItemStack stack) {
        return AbstractLoreItem.LoreCredits.builder().documentName("Lorem Ipsum Codex").loreAuthor("GameTechBC").originalAuthor("Marcus Tullius Cicero").credits("https://www.lipsum.com").volume("Volume I - Example Edition").writtenDate("45 BC (Original)").lastUpdated("October 2025").build();
    }

    @Override
    public GUIColorBuilder getColorSet() {
        return GSLGUIColorThemes.ICE;
    }

    @Override
    public int getFirstWordMargin() {
        return 8;
    }
}

