/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.item;

import com.gametechbc.spelllib.init.GSLGUIColorThemes;
import com.gametechbc.spelllib.network.OpenLoreScreenPacket;
import com.gametechbc.spelllib.utils.GUIColorBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractLoreItem
extends Item {
    public AbstractLoreItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenLoreScreenPacket(hand), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public abstract String getLoreTitle(ItemStack var1);

    public abstract String getLoreSubtitle(ItemStack var1);

    public abstract LorePages getLorePages(ItemStack var1);

    public LoreCredits getLoreCredits(ItemStack stack) {
        return null;
    }

    public GUIColorBuilder getColorSet() {
        return GSLGUIColorThemes.ENDER;
    }

    public int getFirstWordMargin() {
        return 12;
    }

    public static class LoreCredits {
        private final String documentName;
        private final String loreAuthor;
        private final String originalAuthor;
        private final String credits;
        private final String volume;
        private final String writtenDate;
        private final String lastUpdated;

        private LoreCredits(Builder builder) {
            this.documentName = builder.documentName;
            this.loreAuthor = builder.loreAuthor;
            this.originalAuthor = builder.originalAuthor;
            this.credits = builder.credits;
            this.volume = builder.volume;
            this.writtenDate = builder.writtenDate;
            this.lastUpdated = builder.lastUpdated;
        }

        public String getDocumentName() {
            return this.documentName;
        }

        public String getLoreAuthor() {
            return this.loreAuthor;
        }

        public String getOriginalAuthor() {
            return this.originalAuthor;
        }

        public String getCredits() {
            return this.credits;
        }

        public String getVolume() {
            return this.volume;
        }

        public String getWrittenDate() {
            return this.writtenDate;
        }

        public String getLastUpdated() {
            return this.lastUpdated;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String documentName = "";
            private String loreAuthor = "";
            private String originalAuthor = "";
            private String credits = "";
            private String volume = "";
            private String writtenDate = "";
            private String lastUpdated = "";

            public Builder documentName(String documentName) {
                this.documentName = documentName;
                return this;
            }

            public Builder loreAuthor(String loreAuthor) {
                this.loreAuthor = loreAuthor;
                return this;
            }

            public Builder originalAuthor(String originalAuthor) {
                this.originalAuthor = originalAuthor;
                return this;
            }

            public Builder credits(String credits) {
                this.credits = credits;
                return this;
            }

            public Builder volume(String volume) {
                this.volume = volume;
                return this;
            }

            public Builder writtenDate(String writtenDate) {
                this.writtenDate = writtenDate;
                return this;
            }

            public Builder lastUpdated(String lastUpdated) {
                this.lastUpdated = lastUpdated;
                return this;
            }

            public LoreCredits build() {
                return new LoreCredits(this);
            }
        }
    }

    public static class LorePages {
        private final List<List<String>> pages;

        private LorePages(List<List<String>> pages) {
            this.pages = pages;
        }

        public static Builder builder() {
            return new Builder();
        }

        public List<String> getPage(int pageIndex) {
            if (pageIndex < 0 || pageIndex >= this.pages.size()) {
                return List.of();
            }
            return this.pages.get(pageIndex);
        }

        public int getTotalPages() {
            return this.pages.size();
        }

        public static class Builder {
            private final List<List<String>> pages = new ArrayList<List<String>>();

            public Builder page(String ... paragraphs) {
                this.pages.add(List.of(paragraphs));
                return this;
            }

            public Builder page(List<String> paragraphs) {
                this.pages.add(paragraphs);
                return this;
            }

            public LorePages build() {
                return new LorePages(this.pages);
            }
        }
    }
}

