/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.events;

import com.gametechbc.spelllib.init.GSLAttributeRegistry;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="gtbcs_spell_lib")
public class ServerEvents {
    @SubscribeEvent
    public static void onSpellDamage(SpellDamageEvent event) {
        Entity entity = event.getSpellDamageSource().getEntity();
        if (entity instanceof LivingEntity) {
            double critRoll;
            double critChance;
            LivingEntity caster = (LivingEntity)entity;
            double damageMultiplier = caster.getAttributeValue(GSLAttributeRegistry.SPELL_DAMAGE);
            float originalDamage = event.getAmount();
            float modifiedDamage = (float)((double)originalDamage * damageMultiplier);
            if (event.getSpellDamageSource().getDirectEntity() instanceof AbstractMagicProjectile) {
                double projectileDamage = caster.getAttributeValue(GSLAttributeRegistry.MAGIC_PROJECTILE_DAMAGE);
                modifiedDamage = (float)((double)modifiedDamage * projectileDamage);
            }
            if ((critChance = caster.getAttributeValue(GSLAttributeRegistry.SPELL_CRIT_CHANCE)) > 0.0 && (critRoll = caster.getRandom().nextDouble()) < critChance) {
                double critDamage = caster.getAttributeValue(GSLAttributeRegistry.SPELL_CRIT_DAMAGE);
                float finalDamage = (float)((double)modifiedDamage * critDamage);
                event.setAmount(finalDamage);
                if (caster instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)caster;
                    ServerEvents.displayCriticalHit(player, finalDamage, critDamage);
                }
                return;
            }
            event.setAmount(modifiedDamage);
        }
    }

    private static void displayCriticalHit(ServerPlayer player, float critDamage, double critMultiplier) {
    }
}

