/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.entity;

import com.gametechbc.spelllib.init.GSLEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GSLScreenFlashEntity
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.defineId(GSLScreenFlashEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> INTENSITY = SynchedEntityData.defineId(GSLScreenFlashEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> FADE_IN_DURATION = SynchedEntityData.defineId(GSLScreenFlashEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> PEAK_DURATION = SynchedEntityData.defineId(GSLScreenFlashEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FADE_OUT_DURATION = SynchedEntityData.defineId(GSLScreenFlashEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(GSLScreenFlashEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> LESSEN_DISTANCE_FALLOFF = SynchedEntityData.defineId(GSLScreenFlashEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public GSLScreenFlashEntity(EntityType<? extends GSLScreenFlashEntity> type, Level world) {
        super(type, world);
    }

    public GSLScreenFlashEntity(Level world, Vec3 position, float radius, float intensity, int fadeInDuration, int peakDuration, int fadeOutDuration, int color, boolean lessenDistanceFalloff) {
        super((EntityType)GSLEntities.GSL_SCREEN_FLASH.get(), world);
        this.setRadius(radius);
        this.setIntensity(intensity);
        this.setFadeInDuration(fadeInDuration);
        this.setPeakDuration(peakDuration);
        this.setFadeOutDuration(fadeOutDuration);
        this.setColor(color);
        this.setLessenDistanceFalloff(lessenDistanceFalloff);
        this.setPos(position.x, position.y, position.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getFlashAlpha(Player player, float delta) {
        float ticksElapsed = (float)this.tickCount + delta;
        int fadeInDur = this.getFadeInDuration();
        int peakDur = this.getPeakDuration();
        int fadeOutDur = this.getFadeOutDuration();
        Vec3 playerPos = player.getEyePosition(delta);
        double distance = this.position().distanceTo(playerPos);
        if (distance > (double)this.getRadius()) {
            return 0.0f;
        }
        float baseIntensity = this.getIntensity();
        if (this.isLessenDistanceFalloff()) {
            float distanceFalloff = (float)Math.max(0.0, 1.0 - distance / (double)this.getRadius());
            baseIntensity *= distanceFalloff;
        }
        if (ticksElapsed < (float)fadeInDur) {
            if (fadeInDur == 0) {
                return baseIntensity;
            }
            float fadeInProgress = ticksElapsed / (float)fadeInDur;
            return baseIntensity * fadeInProgress;
        }
        if (ticksElapsed < (float)(fadeInDur + peakDur)) {
            return baseIntensity;
        }
        if (ticksElapsed < (float)(fadeInDur + peakDur + fadeOutDur)) {
            if (fadeOutDur == 0) {
                return 0.0f;
            }
            float fadeOutStart = fadeInDur + peakDur;
            float timeInFadeOut = ticksElapsed - fadeOutStart;
            float fadeOutProgress = timeInFadeOut / (float)fadeOutDur;
            return baseIntensity * (1.0f - fadeOutProgress);
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFlashColor() {
        return this.getColor();
    }

    public void tick() {
        super.tick();
        int totalDuration = this.getFadeInDuration() + this.getPeakDuration() + this.getFadeOutDuration();
        if (this.tickCount > totalDuration) {
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder entityData) {
        entityData.define(RADIUS, (Object)Float.valueOf(10.0f));
        entityData.define(INTENSITY, (Object)Float.valueOf(0.8f));
        entityData.define(FADE_IN_DURATION, (Object)3);
        entityData.define(PEAK_DURATION, (Object)2);
        entityData.define(FADE_OUT_DURATION, (Object)10);
        entityData.define(COLOR, (Object)0xFFFFFF);
        entityData.define(LESSEN_DISTANCE_FALLOFF, (Object)false);
    }

    public float getRadius() {
        return ((Float)this.entityData.get(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.entityData.set(RADIUS, (Object)Float.valueOf(radius));
    }

    public float getIntensity() {
        return ((Float)this.entityData.get(INTENSITY)).floatValue();
    }

    public void setIntensity(float intensity) {
        this.entityData.set(INTENSITY, (Object)Float.valueOf(intensity));
    }

    public int getFadeInDuration() {
        return (Integer)this.entityData.get(FADE_IN_DURATION);
    }

    public void setFadeInDuration(int duration) {
        this.entityData.set(FADE_IN_DURATION, (Object)duration);
    }

    public int getPeakDuration() {
        return (Integer)this.entityData.get(PEAK_DURATION);
    }

    public void setPeakDuration(int duration) {
        this.entityData.set(PEAK_DURATION, (Object)duration);
    }

    public int getFadeOutDuration() {
        return (Integer)this.entityData.get(FADE_OUT_DURATION);
    }

    public void setFadeOutDuration(int duration) {
        this.entityData.set(FADE_OUT_DURATION, (Object)duration);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public boolean isLessenDistanceFalloff() {
        return (Boolean)this.entityData.get(LESSEN_DISTANCE_FALLOFF);
    }

    public void setLessenDistanceFalloff(boolean lessen) {
        this.entityData.set(LESSEN_DISTANCE_FALLOFF, (Object)lessen);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setRadius(compound.getFloat("radius"));
        this.setIntensity(compound.getFloat("intensity"));
        this.setFadeInDuration(compound.getInt("fade_in_duration"));
        this.setPeakDuration(compound.getInt("peak_duration"));
        this.setFadeOutDuration(compound.getInt("fade_out_duration"));
        this.setColor(compound.getInt("color"));
        this.setLessenDistanceFalloff(compound.getBoolean("lessen_distance_falloff"));
        this.tickCount = compound.getInt("ticks_existed");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("radius", this.getRadius());
        compound.putFloat("intensity", this.getIntensity());
        compound.putInt("fade_in_duration", this.getFadeInDuration());
        compound.putInt("peak_duration", this.getPeakDuration());
        compound.putInt("fade_out_duration", this.getFadeOutDuration());
        compound.putInt("color", this.getColor());
        compound.putBoolean("lessen_distance_falloff", this.isLessenDistanceFalloff());
        compound.putInt("ticks_existed", this.tickCount);
    }

    public static void createScreenFlash(Level world, Vec3 position, float radius, float intensity, int fadeInDuration, int peakDuration, int fadeOutDuration, int color, boolean lessenDistanceFalloff) {
        if (!world.isClientSide) {
            GSLScreenFlashEntity flash = new GSLScreenFlashEntity(world, position, radius, intensity, fadeInDuration, peakDuration, fadeOutDuration, color, lessenDistanceFalloff);
            world.addFreshEntity((Entity)flash);
        }
    }

    public static void createWhiteFlash(Level world, Vec3 position, float radius, float intensity, int fadeInDuration, int peakDuration, int fadeOutDuration, boolean lessenDistanceFalloff) {
        GSLScreenFlashEntity.createScreenFlash(world, position, radius, intensity, fadeInDuration, peakDuration, fadeOutDuration, 0xFFFFFF, lessenDistanceFalloff);
    }

    public static void createFlashbang(Level world, Vec3 position, float radius, boolean lessenDistanceFalloff) {
        GSLScreenFlashEntity.createScreenFlash(world, position, radius, 0.9f, 1, 3, 20, 0xFFFFFF, lessenDistanceFalloff);
    }
}

