/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.data_managers;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class GSLSwingCounterManager {
    private static final String SWING_COUNTER_TAG = "GSLSwingCounter";

    public static int getSwingCount(ItemStack stack) {
        CompoundTag tag;
        if (stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains(SWING_COUNTER_TAG)) {
            return tag.getInt(SWING_COUNTER_TAG);
        }
        return 1;
    }

    public static void setSwingCount(ItemStack stack, int count) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putInt(SWING_COUNTER_TAG, count));
    }

    public static void incrementSwingCount(ItemStack stack, int maxSwings) {
        int current = GSLSwingCounterManager.getSwingCount(stack);
        GSLSwingCounterManager.setSwingCount(stack, current >= maxSwings ? 1 : current + 1);
    }

    public static void resetSwingCount(ItemStack stack) {
        GSLSwingCounterManager.setSwingCount(stack, 1);
    }
}

