/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.data_managers;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class GSLCooldownsManager {
    private static final String COOLDOWN_TAG = "GSLCooldowns";

    public static int getCooldown(ItemStack stack, String abilityKey) {
        CompoundTag tag;
        if (stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains(COOLDOWN_TAG)) {
            CompoundTag cooldowns = tag.getCompound(COOLDOWN_TAG);
            return cooldowns.getInt(abilityKey);
        }
        return 0;
    }

    public static void setCooldown(ItemStack stack, String abilityKey, int cooldown, int maxCooldown) {
        int cappedCooldown = Math.min(cooldown, maxCooldown);
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
            CompoundTag cooldowns = tag.getCompound(COOLDOWN_TAG);
            cooldowns.putInt(abilityKey, cappedCooldown);
            tag.put(COOLDOWN_TAG, (Tag)cooldowns);
        });
    }

    public static void addCooldown(ItemStack stack, String abilityKey, int amount, int maxCooldown) {
        int newCooldown = Math.min(GSLCooldownsManager.getCooldown(stack, abilityKey) + amount, maxCooldown);
        GSLCooldownsManager.setCooldown(stack, abilityKey, newCooldown, maxCooldown);
    }

    public static void reduceCooldown(ItemStack stack, String abilityKey, int amount) {
        int newCooldown = Math.max(GSLCooldownsManager.getCooldown(stack, abilityKey) - amount, 0);
        GSLCooldownsManager.setCooldown(stack, abilityKey, newCooldown, Integer.MAX_VALUE);
    }

    public static boolean isCooldownActive(ItemStack stack, String abilityKey) {
        return GSLCooldownsManager.getCooldown(stack, abilityKey) > 0;
    }

    public static void tickCooldown(ItemStack stack) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
            if (tag.contains(COOLDOWN_TAG)) {
                CompoundTag cooldowns = tag.getCompound(COOLDOWN_TAG);
                for (String key : cooldowns.getAllKeys()) {
                    int newCooldown = Math.max(cooldowns.getInt(key) - 1, 0);
                    cooldowns.putInt(key, newCooldown);
                }
                tag.put(COOLDOWN_TAG, (Tag)cooldowns);
            }
        });
    }

    public static CompoundTag getAllCooldowns(ItemStack stack) {
        CompoundTag tag;
        if (stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains(COOLDOWN_TAG)) {
            return tag.getCompound(COOLDOWN_TAG);
        }
        return new CompoundTag();
    }

    public static void clearAllCooldowns(ItemStack stack) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.remove(COOLDOWN_TAG));
    }

    public static boolean hasAnyCooldowns(ItemStack stack) {
        CompoundTag cooldowns = GSLCooldownsManager.getAllCooldowns(stack);
        for (String key : cooldowns.getAllKeys()) {
            if (cooldowns.getInt(key) <= 0) continue;
            return true;
        }
        return false;
    }
}

