/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.data_managers;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class GSLCooldownManager {
    private static final String COOLDOWN_TAG = "GSLCooldown";

    public static int getCooldown(ItemStack stack) {
        CompoundTag tag;
        if (stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains(COOLDOWN_TAG)) {
            return tag.getInt(COOLDOWN_TAG);
        }
        return 0;
    }

    public static void setCooldown(ItemStack stack, int cooldown, int maxCooldown) {
        int cappedCooldown = Math.min(cooldown, maxCooldown);
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putInt(COOLDOWN_TAG, cappedCooldown));
    }

    public static void addCooldown(ItemStack stack, int amount, int maxCooldown) {
        int currentCooldown = GSLCooldownManager.getCooldown(stack);
        int newCooldown = Math.min(currentCooldown + amount, maxCooldown);
        GSLCooldownManager.setCooldown(stack, newCooldown, maxCooldown);
    }

    public static void reduceCooldown(ItemStack stack, int amount) {
        int currentCooldown = GSLCooldownManager.getCooldown(stack);
        int newCooldown = Math.max(currentCooldown - amount, 0);
        GSLCooldownManager.setCooldown(stack, newCooldown, Integer.MAX_VALUE);
    }

    public static boolean isCooldownActive(ItemStack stack) {
        return GSLCooldownManager.getCooldown(stack) > 0;
    }

    public static void tickCooldown(ItemStack stack) {
        if (GSLCooldownManager.isCooldownActive(stack)) {
            GSLCooldownManager.reduceCooldown(stack, 1);
        }
    }
}

