/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.utils;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.Team;
import org.joml.Vector3f;

public class GSLGeneralUtils {
    private static final Random RANDOM = new Random();

    public static LivingEntity findNearestTargetIn3D(Level level, LivingEntity caster, double range, boolean ignoreAllies, boolean ignoreTamed, boolean randomSelection) {
        AABB boundingBox = new AABB(caster.getX() - range, caster.getY() - range, caster.getZ() - range, caster.getX() + range, caster.getY() + range, caster.getZ() + range);
        List possibleTargets = level.getEntitiesOfClass(LivingEntity.class, boundingBox, entity -> {
            TamableAnimal tamable;
            if (entity == caster) {
                return false;
            }
            if (ignoreAllies && caster.isAlliedTo((Entity)entity)) {
                return false;
            }
            return !ignoreTamed || !(entity instanceof TamableAnimal) || !(tamable = (TamableAnimal)entity).isTame() || tamable.getOwner() != caster;
        });
        if (possibleTargets.isEmpty()) {
            return null;
        }
        return randomSelection ? (LivingEntity)possibleTargets.get(RANDOM.nextInt(possibleTargets.size())) : (LivingEntity)possibleTargets.stream().min(Comparator.comparingDouble(arg_0 -> ((LivingEntity)caster).distanceToSqr(arg_0))).orElse(null);
    }

    public static void applyFlightBoost(Player player, double boostScale, double targetSpeed, boolean normalizeSpeed, boolean hurtMarked) {
        Vec3 motion = player.getDeltaMovement();
        Vec3 boost = player.getLookAngle().scale(boostScale);
        Vec3 newMotion = motion.add(boost);
        if (normalizeSpeed && newMotion.length() > targetSpeed) {
            newMotion = newMotion.normalize().scale(targetSpeed);
        }
        player.setDeltaMovement(newMotion);
        player.hurtMarked = hurtMarked;
    }

    public static void applyFlightSpeedLimit(Player player, double targetSpeed, boolean normalizeSpeed, boolean hurtMarked) {
        Vec3 motion = player.getDeltaMovement();
        if (normalizeSpeed && motion.length() > targetSpeed) {
            motion = motion.normalize().scale(targetSpeed);
        }
        player.setDeltaMovement(motion);
        player.hurtMarked = hurtMarked;
    }

    public static void applySpin(Entity entity, float spinSpeed) {
        entity.setYRot(entity.getYRot() + spinSpeed);
    }

    public static void maintainHeight(Entity entity, double targetHeight, double hoverStrength) {
        double currentHeight = entity.getY();
        double difference = targetHeight - currentHeight;
        if (Math.abs(difference) > 0.1) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, difference * hoverStrength, 0.0));
        }
    }

    public static void applyKnockback(Entity entity, Vec3 direction, double strength, boolean hurtMarked) {
        Vec3 knockback = direction.normalize().scale(strength);
        entity.setDeltaMovement(knockback);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.hurtMarked = hurtMarked;
        }
    }

    public static double getSquaredDistance(Entity entity1, Entity entity2) {
        return entity1.position().distanceToSqr(entity2.position());
    }

    public static void applyDirectionalBoost(Entity entity, double strength, boolean hurtMarked) {
        Vec3 lookDirection = entity.getLookAngle().normalize().scale(strength);
        entity.setDeltaMovement(lookDirection);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.hurtMarked = hurtMarked;
        }
    }

    public static void applyFriction(Entity entity, double friction) {
        Vec3 velocity = entity.getDeltaMovement().scale(friction);
        entity.setDeltaMovement(velocity);
    }

    public static void instantKill(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.hurt(entity.damageSources().magic(), Float.MAX_VALUE);
        } else {
            entity.remove(Entity.RemovalReason.KILLED);
        }
    }

    public static boolean isAirborne(Entity entity) {
        return !entity.onGround() && !entity.isInWater();
    }

    public static void forceDropHeldItem(LivingEntity entity) {
        for (ItemStack stack : entity.getHandSlots()) {
            entity.spawnAtLocation(stack);
        }
        entity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        entity.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
    }

    public static void doHealingPercentage(LivingEntity livingEntity, float percent) {
        float healAmount = livingEntity.getMaxHealth() * (percent / 100.0f);
        livingEntity.heal(healAmount);
    }

    public static void reduceFallDamage(LivingEntity livingEntity, float reductionFactor) {
        Vec3 motion = livingEntity.getDeltaMovement();
        livingEntity.setDeltaMovement(motion.x, motion.y * (double)(1.0f - reductionFactor), motion.z);
    }

    public static void extinguishFire(LivingEntity livingEntity) {
        if (livingEntity.isOnFire()) {
            livingEntity.clearFire();
        }
    }

    public static boolean isBelowHealthThreshold(LivingEntity livingEntity, float percent) {
        return livingEntity.getHealth() / livingEntity.getMaxHealth() <= percent / 100.0f;
    }

    public static void notifyPlayersInRange(Entity source, Component message, double radius) {
        if (source.level().isClientSide) {
            return;
        }
        source.level().getEntitiesOfClass(ServerPlayer.class, source.getBoundingBox().inflate(radius)).forEach(player -> player.connection.send((Packet)new ClientboundSetActionBarTextPacket(message)));
    }

    public static boolean isPlayerActuallyBlocking(LivingEntity target, LivingEntity attacker) {
        Vec3 attackDirection;
        Player player;
        if (!(target instanceof Player) || !(player = (Player)target).isBlocking()) {
            return false;
        }
        Vec3 playerLookAngle = player.getLookAngle();
        double dotProduct = playerLookAngle.dot(attackDirection = attacker.position().subtract(player.position()).normalize());
        return dotProduct > -0.3;
    }

    public static boolean spawnEntityOnGround(Level level, double x, double z, double minY, double maxY, Function<Vec3, Entity> entityFactory) {
        Vec3 spawnPos;
        Entity entity;
        BlockPos pos = BlockPos.containing((double)x, (double)maxY, (double)z);
        boolean foundGround = false;
        double yOffset = 0.0;
        do {
            VoxelShape shape;
            BlockPos below;
            if (!level.getBlockState(below = pos.below()).isFaceSturdy((BlockGetter)level, below, Direction.UP)) continue;
            if (!level.isEmptyBlock(pos) && !(shape = level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos)).isEmpty()) {
                yOffset = shape.max(Direction.Axis.Y);
            }
            foundGround = true;
            break;
        } while ((pos = pos.below()).getY() >= Mth.floor((double)minY) - 1);
        if (foundGround && (entity = entityFactory.apply(spawnPos = new Vec3(x, (double)pos.getY() + yOffset, z))) != null) {
            level.addFreshEntity(entity);
            return true;
        }
        return false;
    }

    public boolean isAlly(LivingEntity owner, LivingEntity target) {
        return owner.getTeam() != null && owner.getTeam().isAlliedTo((Team)target.getTeam());
    }

    public boolean isTamed(LivingEntity target) {
        if (target instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)target;
            return tamableAnimal.isTame();
        }
        return false;
    }

    public static Vector3f hexToVector3f(String hexColor) {
        String cleanHex = hexColor.startsWith("#") ? hexColor.substring(1) : hexColor;
        int rgb = Integer.parseInt(cleanHex, 16);
        float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb & 0xFF) / 255.0f;
        return new Vector3f(red, green, blue);
    }

    public static Vector3f hexToVector3f(int hexColor) {
        float red = (float)(hexColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(hexColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(hexColor & 0xFF) / 255.0f;
        return new Vector3f(red, green, blue);
    }

    public static int[] hexToRGB255(String hexColor) {
        String cleanHex = hexColor.startsWith("#") ? hexColor.substring(1) : hexColor;
        int rgb = Integer.parseInt(cleanHex, 16);
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return new int[]{red, green, blue};
    }

    public static int[] hexToRGB255(int hexColor) {
        int red = hexColor >> 16 & 0xFF;
        int green = hexColor >> 8 & 0xFF;
        int blue = hexColor & 0xFF;
        return new int[]{red, green, blue};
    }

    public static int hexToRed(String hexColor) {
        return GSLGeneralUtils.hexToRGB255(hexColor)[0];
    }

    public static int hexToGreen(String hexColor) {
        return GSLGeneralUtils.hexToRGB255(hexColor)[1];
    }

    public static int hexToBlue(String hexColor) {
        return GSLGeneralUtils.hexToRGB255(hexColor)[2];
    }

    public static void applyHovering(Entity entity, double baseHoverHeight, double motionSpeed, double deadzone, boolean hurtMarked) {
        double currentY;
        BlockPos groundPos = entity.blockPosition().below();
        while (entity.level().isEmptyBlock(groundPos) && groundPos.getY() > entity.level().getMinBuildHeight()) {
            groundPos = groundPos.below();
        }
        double groundHeight = groundPos.getY() + 1;
        double targetHoverHeight = groundHeight + baseHoverHeight;
        double deltaY = targetHoverHeight - (currentY = entity.getY());
        if (Math.abs(deltaY) > deadzone) {
            Vec3 motion = entity.getDeltaMovement();
            entity.setDeltaMovement(motion.x, deltaY * motionSpeed, motion.z);
        }
        entity.hurtMarked = hurtMarked;
        entity.fallDistance = 0.0f;
        entity.setOnGround(false);
    }
}

