/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.render.overlay;

import com.gametechbc.spelllib.entity.GSLPowerInversionEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ScreenEffectOverlayHelper {
    public static void renderFlashOverlay(GuiGraphics guiGraphics, float alpha, int color) {
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int alphaInt = (int)(alpha * 255.0f);
        int colorWithAlpha = alphaInt << 24 | color & 0xFFFFFF;
        guiGraphics.fill(0, 0, screenWidth, screenHeight, colorWithAlpha);
    }

    public static void renderPowerInversionOverlay(GuiGraphics guiGraphics, GSLPowerInversionEntity.PowerEffectData effectData, boolean shouldInvert, int flashColor) {
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        if (effectData.flashIntensity > 0.0f) {
            float red = (float)(flashColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(flashColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(flashColor & 0xFF) / 255.0f;
            float alpha = effectData.flashIntensity;
            PoseStack poseStack = guiGraphics.pose();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            Matrix4f matrix = poseStack.last().pose();
            buffer.addVertex(matrix, 0.0f, (float)screenHeight, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, (float)screenWidth, (float)screenHeight, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, (float)screenWidth, 0.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(red, green, blue, alpha);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            RenderSystem.disableBlend();
        }
        if (effectData.effectIntensity > 0.0f) {
            if (shouldInvert) {
                ScreenEffectOverlayHelper.renderEnhancedInversionPattern(guiGraphics, screenWidth, screenHeight, effectData.effectIntensity);
            } else {
                ScreenEffectOverlayHelper.renderEnhancedDesaturation(guiGraphics, screenWidth, screenHeight, effectData.effectIntensity);
            }
        }
    }

    public static void renderEnhancedInversionPattern(GuiGraphics guiGraphics, int screenWidth, int screenHeight, float intensity) {
        if (intensity <= 0.0f) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f matrix = poseStack.last().pose();
        float inversionAlpha = Math.min(intensity * 1.5f, 0.95f);
        inversionAlpha *= inversionAlpha;
        buffer.addVertex(matrix, 0.0f, (float)screenHeight, 0.0f).setColor(0.97f, 0.97f, 0.97f, inversionAlpha);
        buffer.addVertex(matrix, (float)screenWidth, (float)screenHeight, 0.0f).setColor(0.97f, 0.97f, 0.97f, inversionAlpha);
        buffer.addVertex(matrix, (float)screenWidth, 0.0f, 0.0f).setColor(0.97f, 0.97f, 0.97f, inversionAlpha);
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(0.97f, 0.97f, 0.97f, inversionAlpha);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float contrastAlpha = intensity * 0.7f;
        contrastAlpha *= contrastAlpha;
        float contrastDarkness = 0.25f;
        buffer.addVertex(matrix, 0.0f, (float)screenHeight, 0.0f).setColor(contrastDarkness, contrastDarkness, contrastDarkness, contrastAlpha);
        buffer.addVertex(matrix, (float)screenWidth, (float)screenHeight, 0.0f).setColor(contrastDarkness, contrastDarkness, contrastDarkness, contrastAlpha);
        buffer.addVertex(matrix, (float)screenWidth, 0.0f, 0.0f).setColor(contrastDarkness, contrastDarkness, contrastDarkness, contrastAlpha);
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(contrastDarkness, contrastDarkness, contrastDarkness, contrastAlpha);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public static void renderEnhancedDesaturation(GuiGraphics guiGraphics, int screenWidth, int screenHeight, float intensity) {
        PoseStack poseStack = guiGraphics.pose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f matrix = poseStack.last().pose();
        float desatAlpha = Math.min(intensity * 1.4f, 1.0f);
        float grayValue = 0.4f;
        buffer.addVertex(matrix, 0.0f, (float)screenHeight, 0.0f).setColor(grayValue, grayValue, grayValue, desatAlpha);
        buffer.addVertex(matrix, (float)screenWidth, (float)screenHeight, 0.0f).setColor(grayValue, grayValue, grayValue, desatAlpha);
        buffer.addVertex(matrix, (float)screenWidth, 0.0f, 0.0f).setColor(grayValue, grayValue, grayValue, desatAlpha);
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(grayValue, grayValue, grayValue, desatAlpha);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public static void renderFullScreenQuad(PoseStack poseStack, int screenWidth, int screenHeight, float red, float green, float blue, float alpha) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f matrix = poseStack.last().pose();
        buffer.addVertex(matrix, 0.0f, (float)screenHeight, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, (float)screenWidth, (float)screenHeight, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, (float)screenWidth, 0.0f, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }
}

