/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.item;

import com.gametechbc.spelllib.GSLDataComponents;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainerMutable;
import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public abstract class AdvancedEchoCurio
extends CurioBaseItem {
    private final Multimap<Attribute, AttributeModifier> attributeMap = HashMultimap.create();
    private static final int EXPERIENCE_COST = 180;

    public AdvancedEchoCurio(Item.Properties properties, Map<Attribute, AttributeModifier> attributes) {
        super(properties.stacksTo(1).rarity(Rarity.EPIC));
        for (Map.Entry<Attribute, AttributeModifier> entry : attributes.entrySet()) {
            this.attributeMap.put((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    protected abstract Map<AbstractSpell, SpellAttributes> getSpellAttributes();

    protected abstract Component getAssignedHoverText();

    protected abstract Component getUnassignedHoverText();

    protected SoundEvent getAssignSound() {
        return SoundEvents.ENCHANTMENT_TABLE_USE;
    }

    protected int selectLevel(AbstractSpell spell, float quality, boolean prioritizeLowerLevel) {
        int maxLevel = spell.getMaxLevel();
        if (!prioritizeLowerLevel) {
            return 1 + Math.round(quality * (float)(maxLevel - 1));
        }
        double adjustedQuality = Math.pow(quality, 0.5);
        int calculatedLevel = 1 + Math.round((float)(adjustedQuality * (double)(maxLevel - 1)));
        return Math.min(calculatedLevel, maxLevel + Math.round((quality - 1.0f) * (float)maxLevel));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        AbstractSpell selectedSpell;
        CompoundTag tag;
        ItemStack stack = player.getItemInHand(hand);
        CompoundTag compoundTag = tag = stack.has(GSLDataComponents.ECHO_CURIO_COMPONENT) ? (CompoundTag)stack.get(GSLDataComponents.ECHO_CURIO_COMPONENT) : new CompoundTag();
        if (tag.getBoolean("spellAssigned")) {
            player.displayClientMessage((Component)Component.translatable((String)"item.gtbcs_spell_lib.spell_imbuing_curio.already_assigned.message").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.totalExperience < 180) {
            player.displayClientMessage((Component)Component.translatable((String)"item.gtbcs_spell_lib.spell_imbuing_curio.not_enough_xp.message").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        Map<AbstractSpell, SpellAttributes> possibleSpells = this.getSpellAttributes();
        if (!possibleSpells.isEmpty() && (selectedSpell = this.selectWeightedRandomSpell(possibleSpells)) != null) {
            SpellAttributes attributes = possibleSpells.get(selectedSpell);
            float quality = attributes.qualityMin + new Random().nextFloat() * (attributes.qualityMax - attributes.qualityMin);
            int levelOfSpell = this.selectLevel(selectedSpell, quality, attributes.prioritizeLowerLevel);
            ISpellContainerMutable spellContainer = ISpellContainer.create((int)1, (boolean)true, (boolean)true).mutableCopy();
            spellContainer.addSpellAtIndex(selectedSpell, levelOfSpell, 0, true);
            ISpellContainer immutableContainer = spellContainer.toImmutable();
            stack.set((Supplier)ComponentRegistry.SPELL_CONTAINER, (Object)immutableContainer);
            tag.putBoolean("spellAssigned", true);
            stack.set(GSLDataComponents.ECHO_CURIO_COMPONENT, (Object)tag);
            player.giveExperiencePoints(-180);
            level.playSound(null, player.blockPosition(), this.getAssignSound(), player.getSoundSource(), 1.0f, 1.0f);
            if (!level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"item.gtbcs_spell_lib.spell_imbuing_curio.success", (Object[])new Object[]{selectedSpell.getDisplayName(null)}).withStyle(ChatFormatting.GREEN), true);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        CompoundTag tag;
        CompoundTag compoundTag = tag = stack.has(GSLDataComponents.ECHO_CURIO_COMPONENT) ? (CompoundTag)stack.get(GSLDataComponents.ECHO_CURIO_COMPONENT) : new CompoundTag();
        if (tag.getBoolean("spellAssigned")) {
            tooltip.add(this.getAssignedHoverText());
        } else {
            tooltip.add(this.getUnassignedHoverText());
            tooltip.add((Component)Component.translatable((String)"item.gtbcs_spell_lib.random_imbue_curio.ex_required.tooltip").withStyle(ChatFormatting.AQUA));
        }
    }

    private AbstractSpell selectWeightedRandomSpell(Map<AbstractSpell, SpellAttributes> possibleSpells) {
        List<Map.Entry> enabledSpells = possibleSpells.entrySet().stream().filter(entry -> ((AbstractSpell)entry.getKey()).isEnabled()).toList();
        int totalWeight = enabledSpells.stream().mapToInt(entry -> ((SpellAttributes)entry.getValue()).weight).sum();
        if (totalWeight <= 0) {
            return null;
        }
        int randomWeight = new Random().nextInt(totalWeight);
        for (Map.Entry entry2 : enabledSpells) {
            if ((randomWeight -= ((SpellAttributes)entry2.getValue()).weight) >= 0) continue;
            return (AbstractSpell)entry2.getKey();
        }
        return null;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        ImmutableMultimap.Builder attributeBuilder = new ImmutableMultimap.Builder();
        for (Attribute attribute : this.attributeMap.keySet()) {
            Holder attributeHolder = BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)attribute);
            for (AttributeModifier modifier : this.attributeMap.get((Object)attribute)) {
                attributeBuilder.put((Object)attributeHolder, (Object)new AttributeModifier(id, modifier.amount(), modifier.operation()));
            }
        }
        return attributeBuilder.build();
    }

    public static class SpellAttributes {
        public final int weight;
        public final boolean prioritizeLowerLevel;
        public final float qualityMin;
        public final float qualityMax;

        public SpellAttributes(int weight, boolean prioritizeLowerLevel, float qualityMin, float qualityMax) {
            this.weight = weight;
            this.prioritizeLowerLevel = prioritizeLowerLevel;
            this.qualityMin = qualityMin;
            this.qualityMax = qualityMax;
        }
    }
}

