/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.events;

import com.gametechbc.spelllib.entity.GSLFollowingScreenShakeEntity;
import com.gametechbc.spelllib.entity.GSLPowerInversionEntity;
import com.gametechbc.spelllib.entity.GSLScreenFlashEntity;
import com.gametechbc.spelllib.entity.GSLScreenShakeEntity;
import com.gametechbc.spelllib.render.overlay.ScreenEffectOverlayHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

@EventBusSubscriber(modid="gtbcs_spell_lib", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && !Minecraft.getInstance().isPaused()) {
            float delta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            float ticksExistedDelta = (float)player.tickCount + delta;
            float shakeAmplitude = 0.0f;
            for (Entity screenShake : player.level().getEntitiesOfClass(GSLScreenShakeEntity.class, player.getBoundingBox().inflate(50.0, 50.0, 50.0))) {
                if (!(screenShake.distanceTo((Entity)player) <= screenShake.getRadius())) continue;
                shakeAmplitude += screenShake.getShakeAmount((Player)player, delta);
            }
            for (Entity screenShake : player.level().getEntitiesOfClass(GSLFollowingScreenShakeEntity.class, player.getBoundingBox().inflate(50.0, 50.0, 50.0))) {
                if (!(screenShake.distanceTo((Entity)player) <= screenShake.getRadius())) continue;
                shakeAmplitude += screenShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            if (shakeAmplitude > 0.0f) {
                event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
                event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
                event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderGuiLayer(RenderGuiLayerEvent.Post event) {
        LocalPlayer player;
        if (event.getName().equals((Object)new ResourceLocation("minecraft", "crosshair")) && (player = Minecraft.getInstance().player) != null && !Minecraft.getInstance().isPaused()) {
            float delta = event.getPartialTick().getGameTimeDeltaPartialTick(true);
            GuiGraphics guiGraphics = event.getGuiGraphics();
            ClientEvents.processScreenFlashEffects((Player)player, delta, guiGraphics);
            ClientEvents.processPowerInversionEffects((Player)player, delta, guiGraphics);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processScreenFlashEffects(Player player, float delta, GuiGraphics guiGraphics) {
        float totalFlashAlpha = 0.0f;
        int flashColor = 0xFFFFFF;
        for (GSLScreenFlashEntity flash : player.level().getEntitiesOfClass(GSLScreenFlashEntity.class, player.getBoundingBox().inflate(50.0, 50.0, 50.0))) {
            float alpha;
            if (!(flash.distanceTo((Entity)player) <= flash.getRadius()) || !((alpha = flash.getFlashAlpha(player, delta)) > totalFlashAlpha)) continue;
            totalFlashAlpha = alpha;
            flashColor = flash.getFlashColor();
        }
        if (totalFlashAlpha > 1.0f) {
            totalFlashAlpha = 1.0f;
        }
        if (totalFlashAlpha > 0.0f) {
            ScreenEffectOverlayHelper.renderFlashOverlay(guiGraphics, totalFlashAlpha, flashColor);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processPowerInversionEffects(Player player, float delta, GuiGraphics guiGraphics) {
        GSLPowerInversionEntity.PowerEffectData combinedEffect = new GSLPowerInversionEntity.PowerEffectData(0.0f, 0.0f, GSLPowerInversionEntity.EffectPhase.NONE);
        boolean shouldInvert = false;
        int flashColor = 0xF8F8F8;
        for (GSLPowerInversionEntity powerEffect : player.level().getEntitiesOfClass(GSLPowerInversionEntity.class, player.getBoundingBox().inflate(50.0, 50.0, 50.0))) {
            if (!(powerEffect.distanceTo((Entity)player) <= powerEffect.getRadius())) continue;
            GSLPowerInversionEntity.PowerEffectData effectData = powerEffect.getEffectData(player, delta);
            if (effectData.phase == GSLPowerInversionEntity.EffectPhase.NONE || !(effectData.flashIntensity > combinedEffect.flashIntensity) && !(effectData.effectIntensity > combinedEffect.effectIntensity)) continue;
            combinedEffect = effectData;
            shouldInvert = powerEffect.shouldInvertColors();
            flashColor = powerEffect.getFlashColor();
        }
        if (combinedEffect.phase != GSLPowerInversionEntity.EffectPhase.NONE) {
            ScreenEffectOverlayHelper.renderPowerInversionOverlay(guiGraphics, combinedEffect, shouldInvert, flashColor);
        }
    }
}

