/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.data_managers;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class GSLWeaponFormManager {
    private static final String FORM_NBT_TAG = "GSLWeaponForms";

    public static int getForm(ItemStack stack) {
        CompoundTag tag;
        if (stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains(FORM_NBT_TAG)) {
            return tag.getInt(FORM_NBT_TAG);
        }
        return 0;
    }

    public static void setForm(ItemStack stack, int form, int maxForms) {
        int cappedForm = Math.max(0, Math.min(form, maxForms - 1));
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putInt(FORM_NBT_TAG, cappedForm));
    }

    public static void cycleForm(ItemStack stack, int maxForms) {
        int currentForm = GSLWeaponFormManager.getForm(stack);
        int newForm = (currentForm + 1) % maxForms;
        GSLWeaponFormManager.setForm(stack, newForm, maxForms);
    }
}

