/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.setup;

import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import com.gametechbc.gametechbcsspellbooks.util.GSTags;
import io.redspace.ironsspellbooks.api.events.SpellOnCastEvent;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.spells.SpellSlot;
import java.util.Arrays;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

@EventBusSubscriber(modid="gametechbcs_spellbooks")
public class ServerEvents {
    private static final String FIRST_LOGIN_TAG = "FirstLoginTOMod";

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
        }
    }

    @SubscribeEvent
    public static void applyCurioBasedSpells(SpellSelectionManager.SpellSelectionEvent event) {
        Player player = event.getEntity();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(a -> {
            List list = a.findCurios(item -> item != null && ISpellContainer.isSpellContainer((ItemStack)item) && item.is(GSTags.SPELL_IMBUED_CURIO));
            for (SlotResult i : list) {
                int initialIndex;
                SpellSlot[] spells;
                ISpellContainer spellContainer = i.stack() != null ? ISpellContainer.get((ItemStack)i.stack()) : null;
                if (spellContainer == null || (spells = spellContainer.getAllSpells()) == null || Arrays.stream(spells).toList().isEmpty()) continue;
                for (int spellIndex = initialIndex = event.getManager().getSpellCount(); spellIndex < initialIndex + spells.length; ++spellIndex) {
                    SpellSlot spell = spells[spellIndex - initialIndex];
                    if (spell == null || spell.getSpell() == null) {
                        return;
                    }
                    event.addSelectionOption(new SpellData(spell.getSpell(), spell.getLevel(), true), i.stack().getItem().getDescriptionId(), spellIndex);
                }
            }
        });
    }

    @SubscribeEvent
    public static void preventEffectRemoval(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null && effectInstance.getEffect() == GSEffects.FROZEN_SIGHT) {
            event.setCanceled(true);
        }
        if (effectInstance != null && effectInstance.getEffect() == GSEffects.CASTING) {
            event.setCanceled(true);
        }
        if (effectInstance != null && effectInstance.getEffect() == GSEffects.AERIAL_COLLAPSE_HELPER) {
            event.setCanceled(true);
        }
        if (effectInstance != null && effectInstance.getEffect() == GSEffects.THIRD_PERSON_SWITCH) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSpellCast(SpellOnCastEvent event) {
        Player caster = event.getEntity();
        if (caster.isDeadOrDying()) {
            return;
        }
        if (caster.hasEffect(GSEffects.HEMORRHAGE)) {
            float maxHp = caster.getMaxHealth();
            float hpToConsume = maxHp * 0.15f;
            caster.hurt(caster.damageSources().magic(), hpToConsume);
        }
    }
}

