/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.effects.MeteorStorm;

import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.spells.fireball.MagicFireball;
import io.redspace.ironsspellbooks.particle.ShockwaveParticleOptions;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MeteorStormEffect
extends MobEffect {
    private int ticksSinceLastSummon = 0;
    private static final int STATIC_OUTER_RADIUS = 24;

    public MeteorStormEffect() {
        super(MobEffectCategory.BENEFICIAL, 0);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level;
        if (!entity.level().isClientSide && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ++this.ticksSinceLastSummon;
            if (this.ticksSinceLastSummon >= 15) {
                this.summonProjectiles(serverLevel, entity, amplifier);
                this.ticksSinceLastSummon = 0;
            }
        }
        return true;
    }

    private void summonProjectiles(ServerLevel serverLevel, LivingEntity meteorStormEntity, int amplifier) {
        RandomSource random = meteorStormEntity.getRandom();
        double innerRadius = 8.0;
        List nearbyEntities = serverLevel.getEntities((Entity)meteorStormEntity, meteorStormEntity.getBoundingBox().inflate(24.0), entity -> {
            LivingEntity target;
            return entity instanceof LivingEntity && !this.isTeammate(meteorStormEntity, target = (LivingEntity)entity) && !this.isTamedCreature(meteorStormEntity, target);
        });
        Collections.shuffle(nearbyEntities, new Random(random.nextLong()));
        int numEntitiesToTarget = Math.min(nearbyEntities.size(), 2);
        for (int i = 0; i < 3; ++i) {
            Vec3 spawnPosition;
            if (i < numEntitiesToTarget) {
                Entity targetEntity = (Entity)nearbyEntities.get(i);
                Vec3 motion = targetEntity.getDeltaMovement();
                double predictionTime = 1.0;
                Vec3 predictedPosition = targetEntity.position().add(motion.scale(predictionTime));
                spawnPosition = new Vec3(predictedPosition.x, predictedPosition.y + 30.0, predictedPosition.z);
                MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)new ShockwaveParticleOptions(((SchoolType)SchoolRegistry.FIRE.get()).getTargetingColor(), -1.5f, true), (double)predictedPosition.x, (double)predictedPosition.y, (double)predictedPosition.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            } else {
                double angle = random.nextDouble() * Math.PI * 2.0;
                double distance = innerRadius + random.nextDouble() * (24.0 - innerRadius);
                double xOffset = Math.cos(angle) * distance;
                double zOffset = Math.sin(angle) * distance;
                double yOffset = 30.0;
                spawnPosition = new Vec3(meteorStormEntity.getX() + xOffset, meteorStormEntity.getY() + yOffset, meteorStormEntity.getZ() + zOffset);
            }
            MagicFireball fireball = new MagicFireball((Level)serverLevel, meteorStormEntity);
            fireball.setPos(spawnPosition);
            fireball.shoot(0.0, -1.0, 0.0, 1.8f, 0.0f);
            fireball.setDamage((float)amplifier);
            fireball.setExplosionRadius(3.5f);
            fireball.setOwner((Entity)meteorStormEntity);
            serverLevel.addFreshEntity((Entity)fireball);
            MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)ParticleHelper.SUNBEAM, (double)spawnPosition.x, (double)spawnPosition.y, (double)spawnPosition.z, (int)1, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (boolean)false);
            MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)ParticleHelper.SUNBEAM, (double)spawnPosition.x, (double)spawnPosition.y, (double)spawnPosition.z, (int)1, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (boolean)true);
        }
    }

    private boolean isTeammate(LivingEntity caster, LivingEntity target) {
        return caster.isAlliedTo((Entity)target);
    }

    private boolean isTamedCreature(LivingEntity caster, LivingEntity target) {
        if (target instanceof TamableAnimal) {
            TamableAnimal tamedAnimal = (TamableAnimal)target;
            return tamedAnimal.isTame() && tamedAnimal.getOwner() == caster;
        }
        return false;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

