/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.effects.LingeringStrain;

import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import com.gametechbc.gametechbcsspellbooks.util.GSDamageTypes;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="gametechbcs_spellbooks")
public class LingeringStrainHandler {
    private static final Map<UUID, PendingDamage> pendingDamage = new HashMap<UUID, PendingDamage>();

    @SubscribeEvent
    public static void onLivingDamageEvent(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (source.is(GSDamageTypes.LINGERING_STRAIN)) {
            return;
        }
        if (entity.hasEffect(GSEffects.LINGERING_STRAIN)) {
            float originalDamage = event.getNewDamage();
            event.setNewDamage(0.0f);
            float phasedDamage = originalDamage / 4.0f;
            pendingDamage.compute(entity.getUUID(), (uuid, existing) -> {
                if (existing == null) {
                    return new PendingDamage(phasedDamage, 4, (ResourceKey<Level>)entity.level().dimension());
                }
                existing.addDamage(phasedDamage);
                return existing;
            });
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        pendingDamage.remove(entity.getUUID());
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (pendingDamage.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<UUID, PendingDamage>> iterator = pendingDamage.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, PendingDamage> entry = iterator.next();
            UUID entityUUID = entry.getKey();
            PendingDamage damage = entry.getValue();
            ServerLevel entityLevel = event.getServer().getLevel(damage.dimension);
            if (entityLevel != null) {
                LivingEntity entity = (LivingEntity)entityLevel.getEntity(entityUUID);
                if (entity != null && entity.isAlive()) {
                    damage.tick(entity);
                    if (!damage.isComplete()) continue;
                    iterator.remove();
                    continue;
                }
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    private static class PendingDamage {
        private float damagePerTick;
        private int ticksRemaining;
        private final ResourceKey<Level> dimension;
        private int tickCounter;

        public PendingDamage(float damagePerTick, int ticksRemaining, ResourceKey<Level> dimension) {
            this.damagePerTick = damagePerTick;
            this.ticksRemaining = ticksRemaining;
            this.dimension = dimension;
            this.tickCounter = 0;
        }

        public void addDamage(float extraDamage) {
            this.damagePerTick += extraDamage / 4.0f;
            this.ticksRemaining += 4;
        }

        public void tick(LivingEntity entity) {
            DamageSource damageSource = new DamageSource(DamageSources.getHolderFromResource((Entity)entity, GSDamageTypes.LINGERING_STRAIN), (Entity)entity, null);
            if (this.ticksRemaining > 0) {
                ++this.tickCounter;
                if (this.tickCounter >= 30) {
                    int armorPieces = 0;
                    for (ItemStack stack : entity.getArmorSlots()) {
                        if (stack.isEmpty()) continue;
                        ++armorPieces;
                    }
                    float armorMultiplier = 1.0f + (float)armorPieces * 0.15f;
                    float adjustedDamage = this.damagePerTick * armorMultiplier;
                    DamageSources.ignoreNextKnockback((LivingEntity)entity);
                    entity.hurt(damageSource, adjustedDamage);
                    --this.ticksRemaining;
                    this.tickCounter = 0;
                    entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.WARDEN_HEARTBEAT, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }

        public boolean isComplete() {
            return this.ticksRemaining <= 0;
        }
    }
}

