/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.world;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.saveddata.SavedData;

public class GAGPointOfInterestStorage
extends SavedData {
    private static final String FILE_NAME = "gag_poi_info";
    private final Map<BlockPos, Holder<Block>> pois = new HashMap<BlockPos, Holder<Block>>();

    public static GAGPointOfInterestStorage get(ServerLevel level) {
        return (GAGPointOfInterestStorage)level.getDataStorage().computeIfAbsent(new SavedData.Factory(GAGPointOfInterestStorage::new, GAGPointOfInterestStorage::load), FILE_NAME);
    }

    public Holder<Block> add(BlockPos pos, Holder<Block> block) {
        this.setDirty();
        return this.pois.put(pos, block);
    }

    public boolean removeIfPresent(BlockPos pos) {
        this.setDirty();
        return this.pois.remove(pos) != null;
    }

    public Optional<BlockPos> checkNearbyPOIs(Holder<Block> block, BlockPos pos, int radius) {
        for (Map.Entry<BlockPos, Holder<Block>> poi : this.pois.entrySet()) {
            if (!poi.getValue().is(block) || !(poi.getKey().distSqr((Vec3i)pos) < (double)(radius * radius))) continue;
            return Optional.of(poi.getKey());
        }
        return Optional.empty();
    }

    public static GAGPointOfInterestStorage load(CompoundTag nbt, HolderLookup.Provider registries) {
        GAGPointOfInterestStorage storage = new GAGPointOfInterestStorage();
        if (nbt.contains("pois")) {
            ListTag list = nbt.getList("pois", 10);
            for (Tag tag : list) {
                CompoundTag poiTag = (CompoundTag)tag;
                Holder block = registries.holderOrThrow(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)poiTag.getString("block"))));
                BlockPos pos = BlockPos.of((long)poiTag.getLong("pos"));
                storage.pois.put(pos, (Holder<Block>)block);
            }
        }
        return storage;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, Holder<Block>> poi : this.pois.entrySet()) {
            list.add((Object)((Tag)Util.make((Object)new CompoundTag(), tag -> {
                tag.putString("block", ((Holder)poi.getValue()).getRegisteredName());
                tag.putLong("pos", ((BlockPos)poi.getKey()).asLong());
            })));
        }
        compoundTag.put("pois", (Tag)list);
        return compoundTag;
    }
}

