/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ky.someone.mods.gag.util.Tooltips;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record TeleportPos(ResourceKey<Level> level, Vec3 pos, float yaw) {
    public static final Codec<TeleportPos> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Level.RESOURCE_KEY_CODEC.fieldOf("level").forGetter(TeleportPos::level), (App)Vec3.CODEC.fieldOf("pos").forGetter(TeleportPos::pos), (App)Codec.FLOAT.fieldOf("yaw").forGetter(TeleportPos::yaw)).apply((Applicative)builder, TeleportPos::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TeleportPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), TeleportPos::level, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Vec3.CODEC), TeleportPos::pos, (StreamCodec)ByteBufCodecs.FLOAT, TeleportPos::yaw, TeleportPos::new);

    public MutableComponent formatPos() {
        return Tooltips.SUCCESS.apply(String.format("(%.1f %.1f %.1f)", this.pos.x, this.pos.y, this.pos.z));
    }

    public MutableComponent formatLevel() {
        ResourceLocation dim = this.level.location();
        return Component.translatableWithFallback((String)Util.makeDescriptionId((String)"dimension", (ResourceLocation)dim), (String)dim.toString());
    }

    public MutableComponent formatFull() {
        return this.formatPos().append((Component)Tooltips.FLAVOUR.apply(" @ ").append((Component)this.formatLevel()));
    }
}

