/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.UnaryOperator;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.integration.emi.EmiPigmentJarFromDyeRecipe;
import ky.someone.mods.gag.integration.emi.EmiPigmentJarMixingRecipe;
import ky.someone.mods.gag.integration.emi.EmiPigmentJarSplittingRecipe;
import ky.someone.mods.gag.item.data.TeleportPos;
import ky.someone.mods.gag.util.GAGUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@EmiEntrypoint
public class GAGEmiPlugin
implements EmiPlugin {
    public static final Random RANDOM = new Random();

    public void register(EmiRegistry registry) {
        ClientLevel level = Objects.requireNonNull(Minecraft.getInstance().level);
        registry.addRecipe((EmiRecipe)new EmiPigmentJarFromDyeRecipe());
        registry.addRecipe((EmiRecipe)new EmiPigmentJarMixingRecipe());
        registry.addRecipe((EmiRecipe)new EmiPigmentJarSplittingRecipe());
        EmiWorldInteractionRecipe hearthstoneEnergizing = EmiWorldInteractionRecipe.builder().id(GAGUtil.id("/hearthstone_energizing")).leftInput((EmiIngredient)EmiStack.of(GAGRegistry.HEARTHSTONE)).output(EmiStack.of(GAGRegistry.ENERGIZED_HEARTHSTONE)).rightInput((EmiIngredient)new CustomNameEmiListIngredient(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{Items.LIGHTNING_ROD.getDefaultInstance(), (ItemStack)Util.make((Object)Items.TRIDENT.getDefaultInstance(), it -> it.enchant(level.holderOrThrow(Enchantments.CHANNELING), 1))})), (Component)Component.translatable((String)"info.gag.lightning_crafting_hint").withColor(11460313)), true).supportsRecipeTree(true).build();
        int uniq = RANDOM.nextInt();
        EmiWorldInteractionRecipe energizedHearthstoneRepairing = EmiWorldInteractionRecipe.builder().id(GAGUtil.id("/energized_hearthstone_repairing")).leftInput((EmiIngredient)EmiStack.EMPTY, s -> new GeneratedSlotWidget(r -> {
            ItemStack stack = GAGRegistry.ENERGIZED_HEARTHSTONE.toStack();
            stack.set(GAGRegistry.TELEPORT_TARGET_DATA, (Object)new TeleportPos((ResourceKey<Level>)level.dimension(), Vec3.ZERO, 0.0f));
            stack.set(GAGRegistry.HIDE_TARGET_DATA, (Object)Unit.INSTANCE);
            int dmg = (int)(r.nextDouble() * (double)stack.getMaxDamage());
            stack.setDamageValue(dmg);
            return EmiStack.of((ItemStack)stack);
        }, uniq, s.getBounds().x(), s.getBounds().y())).output(EmiStack.EMPTY, s -> new GeneratedSlotWidget(r -> {
            ItemStack stack = GAGRegistry.ENERGIZED_HEARTHSTONE.toStack();
            int dmg = (int)((r.nextDouble() - 0.25) * (double)stack.getMaxDamage());
            stack.setDamageValue(Math.max(dmg, 0));
            return EmiStack.of((ItemStack)stack);
        }, uniq, s.getBounds().x(), s.getBounds().y())).rightInput((EmiIngredient)new CustomNameEmiListIngredient(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{Items.LIGHTNING_ROD.getDefaultInstance(), (ItemStack)Util.make((Object)Items.TRIDENT.getDefaultInstance(), it -> it.enchant(level.holderOrThrow(Enchantments.CHANNELING), 1))})), (Component)Component.translatable((String)"info.gag.lightning_crafting_hint").withColor(11460313)), true).supportsRecipeTree(false).build();
        registry.addRecipe((EmiRecipe)hearthstoneEnergizing);
        registry.addRecipe((EmiRecipe)energizedHearthstoneRepairing);
    }

    public static ResourceLocation synthetic(ResourceLocation id) {
        return ResourceLocation.tryBuild((String)id.getNamespace(), (String)("/" + id.getPath()));
    }

    public record CustomNameEmiListIngredient(EmiIngredient wrapped, Component name) implements EmiIngredient
    {
        public List<EmiStack> getEmiStacks() {
            return this.wrapped.getEmiStacks();
        }

        public EmiIngredient copy() {
            return this.copyWith(id -> id);
        }

        private EmiIngredient copyWith(UnaryOperator<EmiIngredient> op) {
            return new CustomNameEmiListIngredient((EmiIngredient)op.apply(this.wrapped), (Component)this.name.copy());
        }

        public long getAmount() {
            return this.wrapped.getAmount();
        }

        public EmiIngredient setAmount(long amount) {
            return this.copyWith(id -> id.setAmount(amount));
        }

        public float getChance() {
            return this.wrapped.getChance();
        }

        public EmiIngredient setChance(float chance) {
            return this.copyWith(id -> id.setChance(chance));
        }

        public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
            this.wrapped.render(draw, x, y, delta, flags);
        }

        public List<ClientTooltipComponent> getTooltip() {
            return (List)Util.make(new ArrayList(this.wrapped.getTooltip()), it -> it.set(0, ClientTooltipComponent.create((FormattedCharSequence)this.name.getVisualOrderText())));
        }
    }
}

